% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_processing.R
\name{batch_processor_db}
\alias{batch_processor_db}
\title{Batch NLP Annotations for a Cohort}
\usage{
batch_processor_db(
  patient_vect,
  text_format,
  nlp_engine,
  URL,
  negex_simp,
  umls_selected,
  uri_fun,
  user,
  password,
  host,
  port,
  database,
  max_n_grams_length,
  negex_depth,
  select_cores
)
}
\arguments{
\item{patient_vect}{Vector of patient ID's.}

\item{text_format}{Text format.}

\item{nlp_engine}{NLP engine, UDPipe only for now.}

\item{URL}{UDPipe model URL.}

\item{negex_simp}{Simplifed negex.}

\item{umls_selected}{Processed UMLS table.}

\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{max_n_grams_length}{Maximum length of tokens for matching with UMLS concept unique identifiers (CUI's). Shorter values will result in faster processing. If ) is chosen, UMLS CUI tags will not be provided.}

\item{negex_depth}{Maximum distance between negation item and token to negate. Shorter distances will result in decreased sensitivity but increased specificity for negation.}

\item{select_cores}{How many CPU cores should be used for parallel processing? Max allowed is total number of cores minus one. If 1 is entered, parallel processing will not be used.}
}
\description{
NLP annotates documents for a cohort of patients, in parallel. Locks each record before proceeding with NLP annotations.
}
\keyword{internal}
