% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_io.R
\name{get_patient}
\alias{get_patient}
\title{Retrieve Patient Data}
\usage{
get_patient(
  uri_fun,
  user,
  password,
  host,
  port,
  database,
  end_user,
  search_query,
  use_negation,
  hide_duplicates,
  patient_id = NA
)
}
\arguments{
\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{end_user}{CEDARS end user name.}

\item{search_query}{Medical corpus query containg keywords/CUI's, boolean elements and other operators ('AND', 'OR', '!', '(', or ')').}

\item{use_negation}{Should negated items be ignored in the keyword/concept search?}

\item{hide_duplicates}{Should duplicated sentences be removed for search results?}

\item{patient_id}{Used if a specific patient record is requested, instead of a search for next record to annotate.}
}
\description{
Retrieves annotated electronic health record sentences for one patient. Returns basic info, along with a dataframe containing sentences and corresponding notes.
}
\keyword{internal}
