% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_io.R
\name{get_wrapper}
\alias{get_wrapper}
\title{Wrap the get_data() Function}
\usage{
get_wrapper(
  database,
  end_user,
  end_user_password,
  html = TRUE,
  position,
  patient_id = NA,
  ldap = FALSE
)
}
\arguments{
\item{database}{MongoDB database.}

\item{end_user}{CEDARS end user name..}

\item{end_user_password}{CEDARS end user password.}

\item{html}{Should output keywords/concepts be highlighted with HTML markup? Default is TRUE.}

\item{position}{Sentence position within the sequence of selected sentences for a given patient.}

\item{patient_id}{Used if a specific patient record is requested, instead of a search for next record to annotate.}

\item{ldap}{Is LDAP authentication being used? If so, password will not be checked and access will be granted automatically.}
}
\value{
A list with patient-specific information and a dataframe with selected sentences along with sentence-specific data.
}
\description{
Obtain one sentence and related info from MongoDB. Uses DB credentials pre-loaded in the main environment. For use with Shiny or REST GET (latter yet to be implemented).
}
\examples{
\dontrun{
get_wrapper(database = 'TEST_PROJECT', end_user = 'John', end_user_password = 'db_password_1234',
html = TRUE, position = NA)
}
}
