################################################################################
#   Copyright (c) 2014-2015 by Martin Zaefferer, Cologne University of Applied Sciences
################################################################################
##	This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see <http://www.gnu.org/licenses/>.
################################################################################

################################################################################
#' Combinatorial Efficient Global Optimization
#'
#' Model building, surrogate model
#' based optimization and Efficient Global Optimization in combinatorial
#' or mixed search spaces.
#'
#' \tabular{ll}{
#' Package: \tab CEGO\cr
#' Type: \tab Package\cr
#' Version: \tab 1.0.1108\cr
#' Date: \tab 06.01.2015\cr
#' License: \tab GPL (>= 3)\cr
#' LazyLoad: \tab yes\cr
#' }
#'
#' @name CEGO-package
#' @aliases CEGO
#' @docType package
#' @title Combinatorial Efficient Global Optimization in R
#' @author Martin Zaefferer \email{mzaefferer@@gmail.com} 
#' @references Zaefferer, Martin; Stork, Joerg; Friese, Martina; Fischbach, Andreas; Naujoks, Boris; Bartz-Beielstein, Thomas. (2014). Efficient global optimization for combinatorial problems. In Proceedings of the 2014 conference on Genetic and evolutionary computation (GECCO '14). ACM, New York, NY, USA, 871-878. DOI=10.1145/2576768.2598282 http://doi.acm.org/10.1145/2576768.2598282 
#' @references Zaefferer, Martin; Stork, Joerg; Bartz-Beielstein, Thomas. (2014). Distance Measures for Permutations in Combinatorial Efficient Global Optimization. In Parallel Problem Solving from Nature - PPSN XIII (p. 373-383). Springer International Publishing.
#' @keywords package
#' @seealso Interface of main function: \code{\link{optimCEGO}} 
#' @import MASS
#' @import stats
#' @import DEoptim
NA #ends description
################################################################################