% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutationDistances.r
\name{distancePermutationHamming}
\alias{distancePermutationHamming}
\title{Hamming Distance for Permutations}
\usage{
distancePermutationHamming(x, y)
}
\arguments{
\item{x}{first permutation (integer vector)}

\item{y}{second permutation (integer vector)}
}
\value{
numeric distance value \deqn{d(x,y)}, scaled to values between 0 and 1 (based on the maximum possible distance between two permutations)
}
\description{
Hamming distance for permutations, scaled to values between 0 and 1.
That is, the number of unequal elements of two permutations, divided by the permutations length.
}
\examples{
x <- 1:5
y <- c(5,1,2,3,4)
distancePermutationHamming(x,y)
p <- replicate(10,sample(1:5),simplify=FALSE)
distanceMatrix(p,distancePermutationHamming)

}

