% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distanceBasedLandscapeGenerators.R
\name{landscapeGeneratorUNI}
\alias{landscapeGeneratorUNI}
\title{Unimodal Fitness Landscape}
\usage{
landscapeGeneratorUNI(ref, distanceFunction)
}
\arguments{
\item{ref}{reference individual}

\item{distanceFunction}{Distance function, used to evaluate d(x,ref), where x is an arbitrary new individual}
}
\value{
returns a function. The function requires a list of candidate solutions as its input, where each solution is suitable for use with the distance function. The function returns a numeric vector.
}
\description{
This function generates uni-modal fitness landscapes based on distance measures.
The fitness is the distance to a reference individual or center. Hence, the reference individual
is the optimum of the landscape. This function is essentially a wrapper
for the \code{\link{landscapeGeneratorMUL}}
}
\examples{
fun <- landscapeGeneratorUNI(ref=1:7,distancePermutationCos)
## for single solutions, note that the function still requires list input:
x <- 1:7
fun(list(x))
x <- 7:1
fun(list(x))
x <- sample(7)
fun(list(x))
## multiple solutions at once:
x <- replicate(5,sample(7),FALSE)
fun(x)

}
\references{
Moraglio, Alberto, Yong-Hyuk Kim, and Yourim Yoon. "Geometric surrogate-based optimisation for permutation-based problems." Proceedings of the 13th annual conference companion on Genetic and evolutionary computation. ACM, 2011.
}
\seealso{
\code{\link{landscapeGeneratorMUL}}, \code{\link{landscapeGeneratorGaussian}}
}
