% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indefiniteLearning.R
\name{correctionDistanceMatrix}
\alias{correctionDistanceMatrix}
\title{Correction of a Distance Matrix}
\usage{
correctionDistanceMatrix(
  mat,
  type = "NSD",
  method = "flip",
  repair = TRUE,
  tol = 1e-08
)
}
\arguments{
\item{mat}{symmetric distance matrix}

\item{type}{string that specifies type of correction: \code{"CNSD"},\code{"NSD"} to enforce CNSD or NSD matrices respectively.}

\item{method}{string that specifies method for correction: spectrum clip \code{"clip"}, spectrum flip \code{"flip"}, nearest definite matrix \code{"near"}, spectrum square\code{"square"}, spectrum diffusion \code{"diffusion"}, feature embedding \code{"feature"}.}

\item{repair}{boolean, whether or not to use condition repair, so that elements are positive, and diagonal is zero.}

\item{tol}{torelance value. Eigenvalues between \code{-tol} and \code{tol} are assumed to be zero.}
}
\value{
list with corrected distance matrix \code{mat}, \code{isCNSD} (boolean, whether original matrix was CNSD) and transformation matrix \code{A}.
}
\description{
Convert (possibly non-euclidean or non-metric) distance matrix with chosen approach so that it becomes a CNSD matrix.
Optionally, the resulting matrix is enforced to have positive elements and zero diagonal, with the \code{repair} parameter.
Essentially, this is a combination of functions \code{\link{correctionDefinite}} or \code{\link{correctionCNSD}} with \code{\link{repairConditionsDistanceMatrix}}.
}
\examples{
x <- list(c(2,1,4,3),c(2,4,3,1),c(4,2,1,3),c(4,3,2,1),c(1,4,3,2))
D <- distanceMatrix(x,distancePermutationInsert)
is.CNSD(D) #matrix should not be CNSD
D <- correctionDistanceMatrix(D)$mat
is.CNSD(D) #matrix should now be CNSD
D
}
\references{
Martin Zaefferer and Thomas Bartz-Beielstein. (2016). Efficient Global Optimization with Indefinite Kernels. Parallel Problem Solving from Nature-PPSN XIV. Accepted, in press. Springer.
}
\seealso{
\code{\link{correctionDefinite}},\code{\link{correctionCNSD}},\code{\link{repairConditionsDistanceMatrix}}
}
