% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_plot.R
\name{CGGPplotblockselection}
\alias{CGGPplotblockselection}
\title{Plot CGGP block selection over time}
\usage{
CGGPplotblockselection(CGGP, indims)
}
\arguments{
\item{CGGP}{CGGP object}

\item{indims}{Which input dimensions should be shown?}
}
\value{
ggplot2 object
}
\description{
Shows the order in which blocks were selected
for each dimension.
Gives an idea of how the selection schange over time.
}
\examples{
gs <- CGGPcreate(d=3, batchsize=100)
f <- function(x){x[1]^1.2+x[3]^.4*sin(2*pi*x[2]^2*3) + .1*exp(3*x[3])}
y <- apply(gs$design, 1, f)
gs <- CGGPfit(gs, Y=y)
CGGPplotblockselection(gs)
}
