% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CHMM_VEM.R
\name{CHMM_VEM}
\alias{CHMM_VEM}
\title{Perform variational inference of coupled Hidden Markov Models.}
\usage{
CHMM_VEM(X, nb.states, S = NULL, omega = 0.7, meth.init = "mclust",
  var.equal = TRUE, itmax = 500, threshold = 1e-07)
}
\arguments{
\item{X}{a data matrix of observations. Columns correspond to individuals.}

\item{nb.states}{a integer specifying the numbers of states.}

\item{S}{a matrix of similarity between individuals.}

\item{omega}{a value of omega.}

\item{meth.init}{a string specifying the initialization method ("mclust" or "kmeans"). The default method is "mclust".}

\item{var.equal}{a logical variable indicating whether to treat the variances as being equal.}

\item{itmax}{an integer specifying the maximal number of iterations for the EM algorithm.}

\item{threshold}{a value for the threshold used for the stopping criteria.}
}
\value{
a list of 9 components
\describe{
\item{\code{postPr}}{a list containing for each series the posterior probabilities. }
\item{\code{initPr}}{ a numeric specifying the initial state probabilities.}
\item{\code{transPr}}{ a matrix of the state transition probabilities.}
\item{\code{esAvg}}{ a numeric of the estimated mean for each state.}
\item{\code{esVar}}{ a numeric of the estimated variance for each state.}
\item{\code{emisPr}}{a list containing for each series the emission probabilities.}
\item{\code{emisPrW}}{a list containing for each series the emission probabilities taking into account for the dependency structure.}
\item{\code{RSS}}{ a numeric corresponding to the Residuals Sum of Squares.}
\item{\code{iterstop}}{ an integer corresponding to the total number of iterations.}
}
}
\description{
Perform variational inference of coupled Hidden Markov Models.
}
\references{
Wang, X., Lebarbier, E., Aubert, J. and Robin, S., Variational inference for coupled Hidden Markov Models applied to the joint detection of copy number variations.
}
