% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.VEM.R
\name{init.VEM}
\alias{init.VEM}
\title{Initialization step of the \code{CHMM_VEM} function.}
\usage{
init.VEM(X, nb.states, meth.init, var.equal, nbI, nbT)
}
\arguments{
\item{X}{a matrix of observations. Columns correspond to series (individuals).}

\item{nb.states}{an integer specifying the numbers of states.}

\item{meth.init}{a string specifying the initialization method ("mclust" or "kmeans"). The default method is "mclust".}

\item{var.equal}{a logical variable indicating whether to treat the variances as being equal (TRUE, value by default) or not (FALSE).}

\item{nbI}{an integer specifying the number of series.}

\item{nbT}{an integer specifying the length of one series.}
}
\value{
A list containing the parameters of the model
\describe{
\item{\code{esAvg}}{ a numeric of the estimated mean for each state.}
\item{\code{esVar}}{ a numeric of the estimated variance for each state.}
\item{\code{transPr}}{ a matrix of the state transition probabilities}
\item{\code{postPr}}{ a list containing for each series the posterior probabilities.}
\item{\code{initPr}}{ a numeric specifying the initial state probabilities}.
}
}
\description{
Initialization step of the \code{CHMM_VEM} function.
}
