% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ModSel.R
\name{plot.ModSel}
\alias{plot.ModSel}
\title{Plot method for sequential model selection}
\usage{
\method{plot}{ModSel}(x, ...)
}
\arguments{
\item{x}{Object of \code{class} ModSel}

\item{...}{other arguments}
}
\description{
Plot method for the sequential model selection option for CICA
}
\examples{
\dontrun{
CICA_data <- Sim_CICA(Nr = 15, Q = 5, R = 4, voxels = 100, timepoints = 10,
E = 0.4, overlap = .25, externalscore = TRUE)

multiple_output = CICA(DataList = CICA_data$X, nComp = 2:6, nClus = 1:5,
userGrid = NULL, RanStarts = 30, RatStarts = NULL, pseudo = c(0.1, 0.2),
pseudoFac = 2, userDef = NULL, scalevalue = 1000, center = TRUE,
maxiter = 100, verbose = TRUE, ctol = .000001)

ModSelOutput <- SequentialScree(multiple_output)

plot(ModSelOutput)
}

}
