% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modRV.R
\name{modRV}
\alias{modRV}
\title{The modified-RV coefficient}
\usage{
modRV(X, Y)
}
\arguments{
\item{X}{first matrix, number of rows in X should corresponds to number of rows in Y}

\item{Y}{second matrix, number of rows in Y should corresponds to number of rows in X}
}
\value{
A single value, indicating the similarity between the two input matrices
}
\description{
The modified-RV coefficient
}
\examples{
\dontrun{
#X1 <- matrix(rnorm(1000), 10)
#SVD <- svd(X1)
#X2 <- SVD$u[,-5] \%*\% diag(SVD$d[-5]) \%*\% t(SVD$v[,-5])
#modRV(X1,X2)
}
}
\references{
Smilde AK, Kiers HAL, Bijlsma S, Rubingh CM, van Erk MJ (2009) Matrix correlations for high-dimensional data: the modified RV-coefficient. Bioinformatics 25(3):401–405
}
\seealso{
\code{\link{computeRVmat}}
}
\author{
Jeffrey Durieux
}
\keyword{internal}
