% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{dangalchev_closeness_centrality}
\alias{dangalchev_closeness_centrality}
\title{Dangalchev Closeness Centrality}
\usage{
dangalchev_closeness_centrality(x, vids = V(x), mode = c("all", "out",
  "in"), weights = NULL)
}
\arguments{
\item{x}{An igraph or a network object}

\item{vids}{Nodes to be considered in the calculation}

\item{mode}{A Character value, indicating whether the shortest paths "in" or "out" of the nodes in the directed graphs should be considered. For undirected graphs we use "all".}

\item{weights}{Numeric vector indicating weights of the edges}
}
\value{
a vector including centrality values for each node
}
\description{
This function computes Dangalchev Closeness Centrality.
This can be access by computing a network resistance. More specifically, it measures the closeness by removing nodes and edges.
The evalauation of this measure of closeness will be easier
and this can be useful for unconnected graphs too.
}
\examples{

data(zachary)

dangalchev_closeness_centrality(zachary)

}
\references{
DANGALCHEV, C. 2006. Residual closeness in networks. Physica A: Statistical Mechanics and its Applications, 365, 556-564. DOI: 10.1016/j.physa.2005.12.020
}
\seealso{
\code{\link[centiserve]{closeness.residual}}
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
