% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{visualize_correlations}
\alias{visualize_correlations}
\title{Correlation plot between centrality measures}
\usage{
visualize_correlations(x, scale = TRUE, method = "pearson")
}
\arguments{
\item{x}{a list indicating calculated centrality measures}

\item{scale}{Whether the centrality values should be scaled or not(default=TRUE)}

\item{method}{a character string describing the type of correlation coefficient (or covariance)
to be computed. The proper values are "pearson", "kendall", or "spearman". (default="pearson")}
}
\value{
The pairwise correlation plot
}
\description{
This function draw correlation plot between pair of centrality measures
}
\details{
This function illustrates pairwise correlation plot of computed centrality measures.
The names of centralities shown in the result plot is abbreviated and compelete names
can be seen in "proper_centralities" function.
Colors from red to blue indicate the intensity of correlation value. If two centrality
measures have an inverse relationship then their correspnding color in plot have to be red
and vice versa.
}
\seealso{
\code{\link[GGally]{ggpairs}}
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
