#' Visuospatial processing ability for 212 subjects
#'
#' Data from Human Connectome Project (HCP). Visuospatial processing is commonly
#' assessed using the Variable Short Penn Line Orientation Test (VSPLOT), where
#' two line segments are presented on the screen and participants are asked to
#' rotate a movable line so that it is parallel to the fixed line. The data
#' contains an indicator of high/low visuospatial processing score for 212
#' subject. The order of the subjects is in the same order as in the array of
#' adjacency matrices data(A).
#'
#' @docType data
#'
#' @usage data(VSPLOT)
#'
#' @references Wang et al. (2017)
#'   (\href{https://arxiv.org/abs/1707.06360}{Arxiv})
#'
#' @source \href{https://github.com/wangronglu/CISE-algorithm}{Github}
"VSPLOT"
