% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_prop_ci.R
\name{single_prop_ci}
\alias{single_prop_ci}
\title{Compute the confidence interval for a single proportion based on different methods}
\usage{
single_prop_ci(
  x,
  n,
  method = "all",
  alternative = "two.sided",
  conf.level = 0.95,
  prior = c(1, 1)
)
}
\arguments{
\item{x}{number of successes}

\item{n}{number of trials}

\item{method}{one of these options "all", "clopper.pearson", "wald", "wislon", "wislon.correct", "agresti", or "beta"}

\item{alternative}{indicates "two.sided", "one.sided"}

\item{conf.level}{confidence level}

\item{prior}{the prior values for "beta" method}
}
\value{
Estimated confidence intervals for the probability of success
}
\description{
Compute the confidence interval for a single proportion based on different methods
}
\examples{
single_prop_ci(53, 57, method = "all")
}
