% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_estimates_naive.R
\name{get_estimates_naive}
\alias{get_estimates_naive}
\title{Naive estimates of the copula and marginal parameters.}
\usage{
get_estimates_naive(Y1 = NULL, Y2 = NULL, predictors_Y1 = NULL,
  predictors_Y2 = NULL, copula_param = "both")
}
\arguments{
\item{Y1}{Numeric vector containing the first phenotype.}

\item{Y2}{Numeric vector containing the second phenotype.}

\item{predictors_Y1}{Dataframe containing the predictors of \code{Y1}
in columns.}

\item{predictors_Y2}{Dataframe containing the predictors of \code{Y2}
in columns.}

\item{copula_param}{String indicating whether estimates should be computed
for \eqn{\phi} (\code{"phi"}), for \eqn{\theta}
(\code{"theta"}), or both (\code{"both"}).}
}
\value{
Vector of the numeric estimates of the copula parameters
        \eqn{log(\phi)} and/or \eqn{log(\theta-1)}, of the marginal
        parameters (\eqn{log(\sigma1), log(\sigma2)}, and estimates
        of the effects of the predictors \code{predictors_Y1}
        on \code{Y1} and \code{predictors_Y2} on \code{Y2}).
}
\description{
Function to compute naive estimates of the copula parameter(s)
and maximum likelihood (ML) estimates of the marginal parameters in a joint
copula model of \code{Y1} and \code{Y2} given the predictors of \code{Y1}
and \code{Y2}. The main use of the function is to provide parameter
starting values for the optimization of the log-likelihood function of the
joint copula model in \code{\link{cjamp}} in order to obtain maximum
likelihood estimates in the copula model.
}
\details{
The estimates of the copula parameter(s) include estimates of \eqn{\phi}
(if \code{copula_param == "phi"}), \eqn{\theta} (if
\code{copula_param == "theta"}) or both (if \code{copula_param == "both"}).
They are obtained by computing Kendall's tau between \code{Y1} and \code{Y2}
and using the relationship \eqn{\tau = \phi/(\phi+2)} of the Clayton
copula to obtain an estimate of \eqn{\phi} and \eqn{\tau = (\theta-1)/\theta}
of the Gumbel copula to obtain an estimate of \eqn{\theta}.

The ML estimates of the marginal parameters include estimates of the log standard
deviations of \code{Y1}, \code{Y2} given their predictors (\eqn{log(\sigma1), log(\sigma2)})
and of the effects of \code{predictors_Y1} on \code{Y1} and
\code{predictors_Y2} on \code{Y2}. The estimates of the marginal effects are
obtained from linear regression models of \code{Y1} given \code{predictors_Y1}
and \code{Y2} given \code{predictors_Y2}, respectively. If single nucleotide
variants (SNVs) are included as predictors, the genetic effect estimates
are obtained from an underlying additive genetic model if SNVs are provided
as 0-1-2 genotypes and from an underlying dominant model if SNVs are provided
as 0-1 genotypes.
}
\examples{
# Generate genetic data:
genodata <- generate_genodata(n_SNV = 20, n_ind = 1000)

# Generate phenotype data:
phenodata <- generate_phenodata_2_copula(genodata = genodata, MAF_cutoff = 1,
                                         prop_causal = 0.5, tau = 0.2,
                                         b1 = 0.3, b2 = 0.3)
predictors <- data.frame(X1 = phenodata$X1, X2 = phenodata$X2,
                         SNV = genodata$SNV1)

get_estimates_naive(Y1 = phenodata$Y1, Y2 = phenodata$Y2,
                    predictors_Y1 = predictors, predictors_Y2 = predictors,
                    copula_param = "both")

}
