% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bgnbd_expectation}
\alias{bgnbd_expectation}
\alias{bgnbd_nocov_expectation}
\alias{bgnbd_staticcov_expectation}
\title{BG/NBD: Unconditional Expectation}
\usage{
bgnbd_nocov_expectation(r, alpha, a, b, vT_i)

bgnbd_staticcov_expectation(r, vAlpha_i, vA_i, vB_i, vT_i)
}
\arguments{
\item{r}{shape parameter of the Gamma distribution of the purchase process}

\item{alpha}{scale parameter of the Gamma distribution of the purchase process}

\item{a}{shape parameter of the Beta distribution of the lifetime process}

\item{b}{shape parameter of the Beta distribution of the lifetime process}

\item{vT_i}{Number of periods since the customer came alive}

\item{vAlpha_i}{Vector of individual parameters alpha}

\item{vA_i}{Vector of individual parameters a}

\item{vB_i}{Vector of individual parameters b}
}
\value{
Returns the expected transaction values according to the chosen model.
}
\description{
Computes the expected number of repeat transactions in the interval (0, vT_i]
for a randomly selected customer, where 0 is defined as the point when the customer came alive.
}
\references{
Fader PS, Hardie BGS, Lee, KL (2005). \dQuote{\dQuote{Counting Your Customers} the Easy Way:
An Alternative to the Pareto/NBD Model} Marketing Science, 24(2), 275–284.

Fader PS, Hardie BGS (2013). \dQuote{Overcoming the BG/NBD Model’s #NUM! Error Problem}
URL \url{http://brucehardie.com/notes/027/bgnbd_num_error.pdf}.

Fader PS, Hardie BGS (2007). \dQuote{Incorporating time-invariant covariates into the
Pareto/NBD and BG/NBD models.}
URL \url{http://www.brucehardie.com/notes/019/time_invariant_covariates.pdf}.
}
