% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health_score_excl_ehv_132kv_tf.R
\name{health_score_excl_ehv_132kv_tf}
\alias{health_score_excl_ehv_132kv_tf}
\title{Health Score Factor for all Assets Categories excl.
EHV and 132kV Transformers}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
health_score_excl_ehv_132kv_tf(
  observed_condition_factor,
  measured_condition_factor
)
}
\arguments{
\item{observed_condition_factor}{Numeric.}

\item{measured_condition_factor}{Numeric.}
}
\value{
Numeric. Health score factor.
}
\description{
This function calculates the health score
factor for all asset categories exclusive the assets EHV
and 132kV transformers. For EHV and 132kV transformers see
\code{\link{mmi}}(). The function combines observed and measured
condition factors using the simplified maximum and
multiple increment (MMI) technique to
construct the health score factor (cf. CNAIM, 2017, page 52, table 9).
}
\examples{
# An asset with an observed condition factor of 1 and a measured condition
# factor of 0.33
 health_score_excl_ehv_132kv_tf(observed_condition_factor = 1,
 measured_condition_factor = 0.33)
}
