% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_transformers.R
\name{financial_cof_transformers}
\alias{financial_cof_transformers}
\title{Financial cost of Failure for Transformers}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
financial_cof_transformers(
  tf_asset_category,
  type_financial_factor_size = NULL,
  type_financial_factor_kva_mva = NULL,
  access_factor_criteria
)
}
\arguments{
\item{tf_asset_category}{String The type of Transformer asset category}

\item{type_financial_factor_size}{String The type financial factor size for Transformer}

\item{type_financial_factor_kva_mva}{Numeric The type financial factor kVA MVA for Transformer}

\item{access_factor_criteria}{String. Asses Financial factor criteria for Transformer
setting (cf. table 214, page 164, CNAIM, 2017).}
}
\value{
Numeric. Financial consequences of failure for Transformer
}
\description{
This function calculates financial consequences of failure
(cf. section 7.3, page 75, CNAIM, 2017). Financial consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
financial_cof_transformers(tf_asset_category = "33kV Transformer (GM)",
type_financial_factor_size = "33/20kV, CMR equivalent",
type_financial_factor_kva_mva = 20,
access_factor_criteria = "Type A")
}
