% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duty_factor_transformer_11_20kv.R
\name{duty_factor_transformer_11_20kv}
\alias{duty_factor_transformer_11_20kv}
\title{Duty Factor for 6.6/11kV and 20kV Transformers}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
duty_factor_transformer_11_20kv(utilisation_pct = "Default")
}
\arguments{
\item{utilisation_pct}{Numeric. The max percentage of utilisation
under normal operating conditions.}
}
\value{
Numeric. Duty factor for 6.6/11kV or 20kV transformer.
}
\description{
This function calculates the duty factor for 6.6/11kV and 20kV
transformers depending on the maximum percentage utilisation under normal
operating conditions.
The duty factor is used in the deriviation of the expected life of an asset.
See e.g. \code{\link{expected_life}()}. For more general information about
the derivation of the duty factor see section 6.6 on page 51 in CNAIM (2021)
}
\examples{
duty_factor_transformer_11_20kv(utilisation_pct = 95)
}
