% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_aggregate.R
\name{copeland}
\alias{copeland}
\title{Copeland scores}
\usage{
copeland(ind_data, w = NULL)
}
\arguments{
\item{ind_data}{A data frame or matrix of indicator data, with observations as rows and indicators
as columns. No other columns should be present (e.g. label columns).}

\item{w}{A vector of weights, which should have length equal to \code{ncol(ind_data)}. Weights are relative
and will be re-scaled to sum to 1. If \code{w} is not specified, defaults to equal weights.}
}
\value{
Numeric vector of Copeland scores.
}
\description{
Aggregates a data frame of indicator values into a single column using the Copeland method. This function is used inside
\code{\link[=aggregate]{aggregate()}}, and calls \code{outrankMatrix()}.
}
\examples{
# get a sample of a few indicators
ind_data <- ASEMIndData[12:16]
# calculate outranking matrix
cop_results <- copeland(ind_data)
# check output
stopifnot(length(cop_results$Scores) == nrow(ind_data))

}
