% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_PCA.R
\name{getPCA}
\alias{getPCA}
\title{Perform PCA on a COIN}
\usage{
getPCA(
  COIN,
  dset = "Raw",
  icodes = NULL,
  aglev = NULL,
  nowarnings = FALSE,
  out2 = "COIN"
)
}
\arguments{
\item{COIN}{An input object. The function can handle either the COIN object, or a data frame.
The data frame should have each column as an indicator, and an optional column \code{"UnitCode"} which
specifies the code (or name) of each unit. Any other type of object will return an error.}

\item{dset}{If input is a COIN object, this specifies which data set in \code{.$Data} to use.}

\item{icodes}{An optional character vector of indicator codes to subset the indicator data. Usefully, can also refer to
an aggregation group name, and data will be sub-setted accordingly. NOTE does not work with multiple aggregate group names.}

\item{aglev}{The aggregation level to take indicator data from. Integer from 1 (indicator level)
to N (top aggregation level, typically the index).}

\item{nowarnings}{If \code{FALSE} (default), will give warnings where missing data are found. Set to \code{TRUE} to suppress these warnings.}

\item{out2}{If the input is a COIN object, this controls where to send the output. If \code{"COIN"}, it
sends the results to the COIN object, otherwise if \code{"list"}, outputs to a separate list.}
}
\value{
If \code{out2 = "COIN"}, results are appended to the COIN object. Specifically:
\itemize{
\item A new set of PCA weights is added to .$Parameters$Weights
\item A list is added to \code{.$Analysis} containing PCA weights (loadings) of the first principle component, and the output of \link[stats:prcomp]{stats::prcomp}, for each
aggregation group found in the targeted level.
If \code{out2 = "list"} the same outputs are contained in a list.
}
}
\description{
Performs Principle Component Analysis (PCA) on a specified data set and subset of indicators or aggregation groups. Returns weights
corresponding to the first principal component, i.e the weights that maximise the variance explained
by the linear combination of indicators.
}
\details{
Note that \code{getPCA()} is simply a quick wrapper for \code{\link[stats:prcomp]{stats::prcomp()}} which makes PCA on COINs quicker.
See \href{https://bluefoxr.github.io/COINrDoc/multivariate-analysis.html#pca}{COINr online documentation} for more details and examples.
}
\examples{
# build ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta,
AggMeta = ASEMAggMeta)
# get PCA results for pillar groups inside "Sust" (sustainability) sub-index
# (warnings about missing data are suppressed)
PCAres <- getPCA(ASEM, dset = "Raw", icodes = "Sust",
aglev = 1, nowarnings = TRUE, out2 = "list")
# summarise PCA results for Social pillar
summary(PCAres$PCAresults$Social$PCAres)

}
\seealso{
\itemize{
\item \link[stats:prcomp]{stats::prcomp} Principle component analysis
}
}
