% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_sensitivity.R
\name{noisyWeights}
\alias{noisyWeights}
\title{Noisy replications of weights}
\usage{
noisyWeights(w, noise_specs, Nrep)
}
\arguments{
\item{w}{A data frame of weights, in the format found in \code{.$Parameters$Weights}.}

\item{noise_specs}{a data frame with columns:
\itemize{
\item \code{AgLevel}: The aggregation level to apply noise to
\item \code{NoiseFactor}: The size of the perturbation: setting e.g. 0.2 perturbs by +/- 20\% of nominal values.
}}

\item{Nrep}{The number of weight replications to generate.}
}
\value{
A list of \code{Nrep} sets of weights (data frames).
}
\description{
Given a set of weights, this function returns multiple replicates of the weights, with added
noise. This is intended for use in uncertainty and sensitivity analysis.
}
\details{
Weights are expected to be in a long data frame format with columns \code{Aglevel}, \code{Code} and \code{Weight}, as
used inside COINs.

Noise is added using the \code{noise_specs} argument, which is specified by a data frame with columns
\code{AgLevel} and \code{NoiseFactor}. The aggregation level refers to number of the aggregation level to target
while the \code{NoiseFactor} refers to the size of the perturbation. If e.g. a row is \code{AgLevel = 1} and
\code{NoiseFactor = 0.2}, this will allow the weights in aggregation level 1 to deviate by +/- 20\% of their
nominal values (the values in \code{w}).
}
\examples{

# build ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta,
AggMeta = ASEMAggMeta)

# generate 2 sets of weights based on original ASEM weights,
# perturbed by +/-20\% only at indicator level
wlist <- noisyWeights(ASEM$Parameters$Weights$Original,
noise_specs = data.frame(AgLevel = 1, NoiseFactor = 0.2), Nrep = 2)

}
\seealso{
\itemize{
\item \code{\link[=sensitivity]{sensitivity()}} Perform global sensitivity or uncertainty analysis on a COIN
}
}
