% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_resultstable.R
\name{getStrengthNWeak}
\alias{getStrengthNWeak}
\title{Generate strengths and weaknesses for a specified unit}
\usage{
getStrengthNWeak(COIN, usel = NULL, topN = 5, bottomN = 5, withcodes = TRUE)
}
\arguments{
\item{COIN}{A COIN}

\item{usel}{A selected unit code}

\item{topN}{The top N indicators to report}

\item{bottomN}{The bottom N indicators to report}

\item{withcodes}{If \code{TRUE} (default), also includes a column of indicator codes. Setting to \code{FALSE} may be more useful
in generating reports, where codes are not helpful.}
}
\value{
A list containing a data frame \code{.$Strengths}, and a data frame \code{.$Weaknesses}.
Each data frame has columns with indicator code, name, rank and value (for the selected unit).
}
\description{
Generates a table of strengths and weaknesses for a selected unit, based on ranks.
}
\details{
This currently only works at the indicator level. Indicators with NA values for the selected unit are ignored.
Strengths and weaknesses mean the top N-ranked indicators for the selected unit. Effectively, this takes the rank that the
selected unit has in each indicator, sorts the ranks, and takes the top N highest and lowest.

NOTE: this function currently requires data to be aggregated. This restriction may be relaxed at some point.
}
\examples{
# build ASEM COIN up to aggregation
ASEM <- build_ASEM()
# generate top 5 strengths and weaknesses for GBR
getStrengthNWeak(ASEM, usel = "GBR")

}
\seealso{
\itemize{
\item \code{\link[=getUnitReport]{getUnitReport()}} Automatic unit report as html, pdf or Word
\item \code{\link[=getUnitSummary]{getUnitSummary()}} Summary of scores for a given unit
}
}
