% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_denominate.R
\name{denominate}
\alias{denominate}
\title{Denominate indicator data sets}
\usage{
denominate(
  obj,
  dset = NULL,
  specby = NULL,
  denomby = NULL,
  scaledenoms = NULL,
  denominators = NULL,
  out2 = "COIN"
)
}
\arguments{
\item{obj}{COIN object or a data frame of indicator data to be denominated. If a data frame, must include a \code{UnitCode} column.}

\item{dset}{The data set to denominate (only if COIN used as input)}

\item{specby}{Selects the source of the specifications for denomination.
\itemize{
\item If \code{"metadata"}, uses the denominator column in \code{.$metadata}.
\item If \code{"user"}, takes a character vector of denominator codes (one for each indicator, with \code{NA} for indicators that should not be denominated, and in the same order as the indicators).
}}

\item{denomby}{Character vector specifying which denominators to use for each indicator. Only used if
\code{specby = "user"}. For indicators with no denomination, set elements to \code{NA.} Elements must be column names
of denominators.}

\item{scaledenoms}{This allows the possibility to scale denominators if needed. For example, if GDP is a denominator and is measured in
dollars, dividing will create very small numbers (order 1e-10 and smaller) which could cause problems with numerical precision. This should be
a named list of the form e.g. \code{list(Den_GDP = 1e-9)}, where the name is the denominator to be scaled, and the entry is a factor to multiply
the denominator values by. In the example, this would multiply GDP values by 1e-9, which (if the original values are in dollars) would
scale them to billions of dollars. The list can include more than one entry, corresponding to any denominators that are present.}

\item{denominators}{A data frame of denominator data. Columns should be denominator data, with column names corresponding
to entries in \code{denomby}. This must also include a \code{UnitCode} column to match units (ordering is unimportant, this is done inside the function).
Ensure that the unit codes correspond to the unit codes in the indicator data.}

\item{out2}{Where to output the results. If \code{"COIN"} (default for COIN input), appends to updated COIN,
otherwise if \code{"df"} outputs to data frame.}
}
\value{
If \code{out2 = COIN} and \code{obj} is a COIN, returns an updated COIN object, with new dataset \code{.$Data$Denominated} of denominated indicators.
Otherwise returns a data frame of denominated indicator data.
}
\description{
Denominates (divides) indicators by other "denominator" indicators that are either input here or were attached as \code{"Den_*"} columns of
\code{IndData} when assembling the COIN. This function can work either on COINs or on data frames.
}
\details{
Typically, the aim here is to convert extensive (size-related) variables into intensive variables(comparable between units
of different sizes). There is also the option \code{scaledenoms} to scale denominators to avoid very small or very large numbers resulting.

This function expects that \code{denominators$UnitCode} contains all unit codes found in the data frame to be denominated. Unused
unit codes (rows) in \code{denominators} will be ignored. Note that some national-level denominator data is available inside COINr at \code{COINr::WorldDenoms}.

See \href{https://bluefoxr.github.io/COINrDoc/denomination.html}{online documentation} for further details and examples.
}
\examples{
# assemble ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# denominate using specs present on assembly
ASEM <- denominate(ASEM, dset = "Raw")

# OR, use function on data frame
# Get a sample of indicator data (note must be indicators plus a "UnitCode" column)
IndData <- ASEMIndData[c("UnitCode", "Goods", "Services", "FDI")]
# Also get some denominator data
Denoms <- ASEMIndData[c("UnitCode", "Den_Pop", "Den_GDP")]
# Denominate one by the other
IndDataDenom <- denominate(IndData, denomby = c("Den_GDP", NA, "Den_Pop"), denominators = Denoms)

}
\seealso{
\itemize{
\item \link{WorldDenoms} A data set of some common national-level denominators.
}
}
