% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dist.R
\name{plot_dist}
\alias{plot_dist}
\title{Static indicator distribution plots}
\usage{
plot_dist(
  coin,
  dset,
  iCodes,
  ...,
  type = "Box",
  normalise = FALSE,
  global_specs = NULL
)
}
\arguments{
\item{coin}{The coin object, or a data frame of indicator data}

\item{dset}{The name of the data set to apply the function to, which should be accessible in \code{.$Data}.}

\item{iCodes}{Indicator code(s) to plot. See details.}

\item{...}{Further arguments passed to \code{\link[=get_data]{get_data()}} (other than \code{coin}, \code{dset} and \code{iCodes}).}

\item{type}{The type of plot. Currently supported \code{"Box"}, \code{"Dot"}, \code{"Violin"}, \code{"Violindot"}, \code{"Histogram"}.}

\item{normalise}{Logical: if \code{TRUE}, normalises the data first, using \code{global_specs}. If \code{FALSE} (default),
data is not normalised.}

\item{global_specs}{Specifications for normalising data if \code{normalise = TRUE}. This is passed to the
\code{global_specs} argument of \code{\link[=Normalise]{Normalise()}}.}
}
\value{
A ggplot2 plot object.
}
\description{
Plots indicator distributions using box plots, dot plots, violin plots, violin-dot plots, and histograms.
Supports plotting multiple indicators by calling aggregation groups.
}
\details{
This function uses ggplot2 to generate plots, so the plot can be further manipulated using ggplot2 commands.
See \verb{vignette("visualisation}) for more details on plotting.
}
\examples{
# build example coin
coin <- build_example_coin(up_to = "new_coin")

# plot all indicators in P2P group
plot_dist(coin, dset = "Raw", iCodes = "P2P", Level = 1, type = "Violindot")

}
