% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{n_dist2ref}
\alias{n_dist2ref}
\title{Normalise as distance to reference value}
\usage{
n_dist2ref(x, iref, cap_max = FALSE)
}
\arguments{
\item{x}{A numeric vector}

\item{iref}{An integer which indexes \code{x} to specify the reference value. The reference value will be
\code{x[iref]}.}

\item{cap_max}{If \code{TRUE}, any value of \code{x} that exceeds \code{x[iref]} will be assigned a score of 1, otherwise
will have a score greater than 1.}
}
\value{
Numeric vector
}
\description{
A measure of the distance to a specific value found in \code{x}, specified by \code{iref}. The formula is:
}
\details{
\deqn{ 1 - (x_{ref} - x)/(x_{ref} - x_{min}) }

Values exceeding \code{x_ref} can be optionally capped at 1 if \code{cap_max = TRUE}.
}
\examples{
x <- runif(20)
n_dist2ref(x, 5)

}
