% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regen.R
\name{change_ind}
\alias{change_ind}
\title{Add and remove indicators}
\usage{
change_ind(coin, add = NULL, drop = NULL, regen = FALSE)
}
\arguments{
\item{coin}{coin object}

\item{add}{A character vector of indicator codes to add (must be present in the original input data)}

\item{drop}{A character vector of indicator codes to remove (must be present in the original input data)}

\item{regen}{Logical (default): if \code{TRUE}, automatically regenerates the results based on the new specs
Otherwise, just updates the \code{.$Log} parameters. This latter might be useful if you want to
Make other changes before re-running using the \code{\link[=Regen]{Regen()}} function.}
}
\value{
An updated coin, with regenerated results if \code{regen = TRUE}.
}
\description{
A shortcut function to add and remove indicators. This will make the relevant changes
and recalculate the index if asked. Adding and removing is done relative to the current set of
indicators used in calculating the index results. Any indicators that are added must of course be
present in the original \code{iData} and \code{iMeta} that were input to \code{new_coin()}.
}
\details{
See also \code{vignette("adjustments")}.

This function replaces the now-defunct \code{indChange()} from COINr < v1.0.
}
\examples{
# build full example coin
coin <- build_example_coin(quietly = TRUE)

# exclude two indicators and regenerate
# remove two indicators and regenerate the coin
coin_remove <- change_ind(coin, drop = c("LPI", "Forest"), regen = TRUE)

coin_remove

}
