% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CONS.R
\name{CONS}
\alias{CONS}
\title{Consonance Analysis Module}
\usage{
CONS()
}
\value{
CONS is a graphic interface
}
\description{
Consonance Analysis is a useful numerical and graphical approach for evaluating the consistency of the measurements and the panel of people involved in sensory evaluation. It makes use of several uni and multivariate techniques either graphical or analytical.

You can learn more about this package at:
http://www.uv.mx/personal/nehuerta/cons/
}
\details{
CONS is a package with a graphical interface that performs Consonance Analysis. This procedure is an
approach useful for evaluating the consistency of the measurements performed by a panel of people
involved in sensory evaluation. It makes use of several uni and multivariate techniques either graphical
or analytical. The procedure helps evaluate the linearirty of an attribute with respect to the panel
performance. If there is evidence that an attribute is not linear then this information could be used to
improve the evaluation of such characteristic. The method also helps detect whether some members of
the panel deviate from the rest. A critical tool for this procedure is Principal Components Analysis.
}
\examples{
\dontrun{
##Install package
library(CONS)
##Call the package
CONS()
}

}
\author{
Nery Sofia Huerta-Pacheco, Victor Manuel Aguirre-Torres, Teresa Lopez-Alvarez
}
\references{
Arnold GM, Williams AA (1985). "The Use of Generalised Procrusters Analysis in
Sensory Analysis". In JR Piggot (ed.) Statistical Procedures in Food Research.
North Holland, Amsterdam.

Banfield CF, Harries JM (1975). " A Techniques for Comparing Judges' Performance
in Sensory Tests". Journal of Food Technology, 10, 1-10.

Dijksterhuis GB, Gower JC (1991/92). "The Interpretation of Generalised Procrusters
Analysis and Allied Methods". Food Quality and Preference, 3, 67-87.

Dijksterhuis GB (1995). "Assessing Panel Consonance". Food Quality and Preference,
6(1):714. http://dx.doi.org/10.1016/0950-3293(94)P4207-M

Dijksterhuis GB (2004). "Assessing Panel Consonance". Multivariate Data Analysis in
Sensory and Consumer Science. ISBN: 978-0-917678-41-7. DOI: 10.1002/9780470385050.ch2

Gower JC (1975). "Generalised Procrusters Analysis." Psychometrika, 40, 33-51.

Sebastien Le, Julie Josse, Francois Husson (2008). FactoMineR: An R Package for
Multivariate Analysis. Journal of Statistical Software, 25(1), 1-18.
10.18637/jss.v025.i01

van der Burg E (1988). "Nonlinear Canonical Correlation and Some Related Techniques."
DSWO press, Leiden.

van der Burg E, Dijksterhuis GB (1989). "Nonlinear Canonical Correlation Analysis
of Multiway Data". In R Coppi, S Bolasco (eds.) Multiway Data Analysis, 245-255.
North-Holland, Elsevier Science Publishers B.V.
}

