% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/italy.R
\name{italy}
\alias{italy}
\title{Coronavirus COVID-19 data - Italy}
\usage{
italy(type = "state")
}
\arguments{
\item{type}{one of \code{country} (data by country), \code{state} (data by region) or \code{city} (data by city). Default \code{state}, data by region.}
}
\value{
Tidy format \code{tibble} (\code{data.frame}) grouped by id:
\describe{
 \item{id}{id in the form "country|state|city".}
 \item{date}{date.}
 \item{country}{administrative area level 1.}
 \item{state}{administrative area level 2.}
 \item{city}{administrative area level 3.}
 \item{lat}{latitude.}
 \item{lng}{longitude.}
 \item{deaths}{the number of deaths.}
 \item{confirmed}{the number of cases.}
 \item{tests}{the number of tests.}
 \item{deaths_new}{daily increase in the number of deaths.}
 \item{confirmed_new}{daily increase in the number of cases.}
 \item{tests_new}{daily increase in the number of tests.}
 \item{pop}{total population.}
 \item{pop_14}{population ages 0-14 (\% of total population).}
 \item{pop_15_64}{population ages 15-64 (\% of total population).}
 \item{pop_65}{population ages 65+ (\% of total population).}
 \item{pop_age}{median age of population.}
 \item{pop_density}{population density per km2.}
 \item{pop_death_rate}{population mortality rate.}
}
}
\description{
Tidy format dataset of the 2019 Novel Coronavirus COVID-19 (2019-nCoV) epidemic.
Italian data by country, state (regions) or city.
The data are downloaded in real-time, processed and merged with demographic indicators (\code{\link{IT}}).
}
\details{
Data pulled from the \href{https://github.com/pcm-dpc/COVID-19}{repository} for the
2019 Novel Coronavirus by Ministero della Salute, \href{http://www.protezionecivile.it/}{Dipartimento della Protezione Civile, Italia}.
}
\examples{
# data by country
x <- italy("country")

# data by region
x <- italy("state")

# data by city
x <- italy("city")

}
\seealso{
\code{\link{world}}, \code{\link{diamond}}, \code{\link{switzerland}}
}
