% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covid19.R
\name{covid19}
\alias{covid19}
\title{COVID-19 Data Hub}
\source{
\url{https://covid19datahub.io}
}
\usage{
covid19(
  country = NULL,
  level = 1,
  start = "2010-01-01",
  end = Sys.Date(),
  raw = FALSE,
  vintage = FALSE,
  verbose = TRUE,
  cache = TRUE,
  wb = NULL,
  gmr = NULL,
  amr = NULL
)
}
\arguments{
\item{country}{vector of country names or \href{https://github.com/covid19datahub/COVID19/blob/master/inst/extdata/db/ISO.csv}{ISO codes} (alpha-2, alpha-3 or numeric).}

\item{level}{integer. Granularity level. 1: country-level data. 2: state-level data. 3: lower-level data.}

\item{start}{the start date of the period of interest.}

\item{end}{the end date of the period of interest.}

\item{raw}{logical. Skip data cleaning? Default \code{FALSE}. See details.}

\item{vintage}{logical. Retrieve the snapshot of the dataset that was generated at the \code{end} date instead of using the latest version. Default \code{FALSE}.}

\item{verbose}{logical. Print data sources? Default \code{TRUE}.}

\item{cache}{logical. Memory caching? Significantly improves performance on successive calls. Default \code{TRUE}.}

\item{wb}{character vector of \href{https://data.worldbank.org}{World Bank} indicator codes. See details.}

\item{gmr}{url to the \href{https://www.google.com/covid19/mobility/}{Google Mobility Report} dataset. See details.}

\item{amr}{url to the \href{https://www.apple.com/covid19/mobility}{Apple Mobility Report} dataset. See details.}
}
\value{
Grouped \code{tibble} (\code{data.frame}). See the \href{https://covid19datahub.io/articles/doc/data.html}{dataset documentation}
}
\description{
Download COVID-19 data across governmental sources at national, regional, and city level.
Includes policy measures by \href{https://www.bsg.ox.ac.uk/covidtracker}{Oxford COVID-19 Government Response Tracker}
and provides a seamless integration with 
\href{https://data.worldbank.org/}{World Bank Open Data}, 
\href{https://www.google.com/covid19/mobility/}{Google Mobility Reports}, 
\href{https://www.apple.com/covid19/mobility}{Apple Mobility Reports}.
}
\details{
If \code{raw=TRUE}, the raw data are cleaned by filling missing dates with \code{NA} values. 
This ensures that all locations share the same grid of dates and no single day is skipped. 
Then, \code{NA} values are replaced with the previous non-\code{NA} value or \code{0}.
Policies for administrative areas level 2 and 3 are inherited from national-level policies.

The dataset can be extended with \href{https://data.worldbank.org}{World Bank Open Data} via the argument \code{wb}, a character vector of indicator codes.
The codes can be found by inspecting the corresponding URL. For example, the code of the GDP indicator available at \url{https://data.worldbank.org/indicator/NY.GDP.MKTP.CD} is \code{NY.GDP.MKTP.CD}.
The latest data available between the \code{start} and \code{end} date are downloaded.

The dataset can be extended with \href{https://www.google.com/covid19/mobility/}{Google Mobility Reports} via the argument \code{gmr}, the url to the Google CSV file.
At the time of writing, the CSV is available \href{https://www.gstatic.com/covid19/mobility/Global_Mobility_Report.csv}{here}. 

The dataset can be extended with \href{https://www.apple.com/covid19/mobility}{Apple Mobility Reports} via the argument \code{amr}, the url to the Apple CSV file.
At the time of writing, the CSV is available \href{https://covid19-static.cdn-apple.com/covid19-mobility-data/2012HotfixDev8/v3/en-us/applemobilitytrends-2020-07-09.csv}{here}.
}
\note{
We have invested a lot of time and effort in creating \href{https://covid19datahub.io}{COVID-19 Data Hub}, please:

\itemize{
\item cite \href{https://doi.org/10.21105/joss.02376}{Guidotti and Ardia (2020)} when using \href{https://covid19datahub.io}{COVID-19 Data Hub}.
\item place the URL \url{https://covid19datahub.io} in a footnote to help others find \href{https://covid19datahub.io}{COVID-19 Data Hub}.
\item you assume full risk for the use of \href{https://covid19datahub.io}{COVID-19 Data Hub}. 
We try our best to guarantee the data quality and consistency and the continuous filling of the Data Hub. 
However, it is free software and comes with ABSOLUTELY NO WARRANTY. 
Reliance on \href{https://covid19datahub.io}{COVID-19 Data Hub} for medical guidance or use of \href{https://covid19datahub.io}{COVID-19 Data Hub} in commerce is strictly prohibited.
}
}
\examples{
\dontrun{

# Worldwide data by country
x <- covid19()

# Worldwide data by state
x <- covid19(level = 2)

# Specific country data by city
x <- covid19(c("Italy","US"), level = 3)

# Merge with World Bank data. It may take some time...
wb <- c("gdp" = "NY.GDP.MKTP.CD", "hosp_beds" = "SH.MED.BEDS.ZS")
x  <- covid19(wb = wb)

# Merge with Google Mobility Reports. It may take some time...
gmr <- "https://www.gstatic.com/covid19/mobility/Global_Mobility_Report.csv"
x   <- covid19(gmr = gmr)

# Merge with Apple Mobility Reports. It may take some time...
amr <- "https://covid19-static.cdn-apple.com/covid19-mobility-data/"
amr <- paste0(amr, "2012HotfixDev8/v3/en-us/applemobilitytrends-2020-07-09.csv")
x   <- covid19(amr = amr)

# Data sources
s <- covid19cite(x)
View(s)
}

}
\references{
Guidotti, E., Ardia, D., (2020), "COVID-19 Data Hub", Journal of Open Source Software 5(51):2376, \doi{10.21105/joss.02376}.
}
