% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covid_deflator.R
\name{covid_deflator}
\alias{covid_deflator}
\title{Add deflator variables to PNAD COVID19 microdata}
\usage{
covid_deflator(data_covid, deflator.file)
}
\arguments{
\item{data_covid}{A tibble of PNAD COVID19 microdata read with \code{read_covid} function.}

\item{deflator.file}{The deflator file for selected survey available on official website: (select the deflator zip file) - \url{https://ftp.ibge.gov.br/Trabalho_e_Rendimento/Pesquisa_Nacional_por_Amostra_de_Domicilios_PNAD_COVID19/Microdados/Documentacao/}.}
}
\value{
A tibble with the data provided from PNAD COVID19 survey and the deflator variables added for use.
}
\description{
This function adds deflator variables to PNAD COVID19 microdata. For deflation of income variables, the documentation provided through the following address must be used: \url{https://ftp.ibge.gov.br/Trabalho_e_Rendimento/Pesquisa_Nacional_por_Amostra_de_Domicilios_PNAD_COVID19/Microdados/Documentacao/COVIDIBGE_Deflator.pdf}.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/investigacoes-experimentais/estatisticas-experimentais/27946-divulgacao-semanal-pnadcovid1?t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
# Using data read from disk
data_path <- covid_example(path="exampledata.csv")
dictionary.path <- covid_example(path="dictionaryexample.xls")
deflator.path <- covid_example(path="deflatorexample.xls")
covid.df <- read_covid(microdata=data_path, vars="C002")
covid.df <- covid_labeller(data_covid=covid.df, dictionary.file=dictionary.path)
covid.df <- covid_deflator(data_covid=covid.df, deflator.file=deflator.path)
\donttest{
# Downloading data
covid.df2 <- get_covid(year=2020, month=5, vars="C002",
                       labels=TRUE, deflator=FALSE, design=FALSE, savedir=tempdir())
deflator.path2 <- covid_example(path="deflatorexample.xls")
covid.df2 <- covid_deflator(data_covid=covid.df2, deflator.file=deflator.path2)}
}
\seealso{
\link[COVIDIBGE]{get_covid} for downloading, labelling, deflating and creating survey design object for PNAD COVID19 microdata.\cr \link[COVIDIBGE]{read_covid} for reading PNAD COVID19 microdata.\cr \link[COVIDIBGE]{covid_labeller} for labelling categorical variables from PNAD COVID19 microdata.\cr \link[COVIDIBGE]{covid_design} for creating PNAD COVID19 survey design object.\cr \link[COVIDIBGE]{covid_example} for getting the path of the PNAD COVID19 example files.
}
