% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.R
\name{covid_example}
\alias{covid_example}
\title{Get the path of the PNAD COVID19 toy example files}
\usage{
covid_example(path = NULL)
}
\arguments{
\item{path}{Name of file. If \code{NULL}, the PNAD COVID19 toy example files names will be listed.}
}
\value{
A vector with names of all the available PNAD COVID19 toy example files or the path for specific requested PNAD COVID19 toy example file.
}
\description{
This function provides the path of the microdata from month 5 of year 2020 of the PNAD COVID19 toy example files, loaded with this package.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/investigacoes-experimentais/estatisticas-experimentais/27946-divulgacao-semanal-pnadcovid1?t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
covid_example()
covid_example(path="exampledata.csv")
covid_example(path="dictionaryexample.xls")
covid_example(path="deflatorexample.xls")
}
\seealso{
\link[COVIDIBGE]{get_covid} for downloading, labeling, deflating and creating survey design object for PNAD COVID19 microdata.\cr \link[COVIDIBGE]{read_covid} for reading PNAD COVID19 microdata.\cr \link[COVIDIBGE]{covid_labeller} for labeling categorical variables from PNAD COVID19 microdata.\cr \link[COVIDIBGE]{covid_deflator} for adding deflator variables to PNAD COVID19 microdata.\cr \link[COVIDIBGE]{covid_design} for creating PNAD COVID19 survey design object.
}
