% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inner_functions.R
\name{read10x}
\alias{read10x}
\title{Load 10x count matrices}
\usage{
read10x(
  data.path,
  samples = NULL,
  raw = FALSE,
  symbol = TRUE,
  sep = "!!",
  unique.names = TRUE,
  n.cores = 1,
  verbose = TRUE
)
}
\arguments{
\item{data.path}{Path to cellranger count data.}

\item{samples}{Vector of sample names (default = NULL)}

\item{raw}{logical Add raw count matrices (default = FALSE)}

\item{symbol}{The type of gene IDs to use, SYMBOL (TRUE) or ENSEMBLE (default = TRUE).}

\item{sep}{Separator for cell names (default = "!!").}

\item{n.cores}{Number of cores for the calculations (default = 1).}

\item{verbose}{Print messages (default = TRUE).}
}
\value{
data frame
}
\description{
Load gene expression count data
}
\examples{
\dontrun{
cms <- read10x(data.path = "/path/to/count/data", 
samples = crm$metadata$samples, 
raw = FALSE, 
symbol = TRUE, 
n.cores = crm$n.cores)
}
}
\keyword{internal}
