% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{anonymize_site}
\alias{anonymize_site}
\title{Anonymize locations of a trial site}
\usage{
anonymize_site(trial, ID = NULL, latvar = "lat", longvar = "long")
}
\arguments{
\item{trial}{\code{"CRTsp"} object or trial data frame with co-ordinates of households}

\item{ID}{name of column used as an identifier for the points}

\item{latvar}{name of column containing latitudes in decimal degrees}

\item{longvar}{name of column containing longitudes in decimal degrees}
}
\value{
A list of class \code{"CRTsp"}.
}
\description{
\code{anonymize_site} transforms coordinates to remove potential identification information.
}
\details{
The coordinates are transformed to support confidentiality of
information linked to households by replacing precise geo-locations with transformed co-ordinates which preserve distances
but not positions. The input may have either \code{lat long} or \code{x,y} coordinates.
The function first searches for any \code{lat long} co-ordinates and converts these to \code{x,y}
Cartesian coordinates. These are then are rotated by a random angle about a random origin. The returned object
has transformed co-ordinates re-centred at the origin. Centroids stored in the \code{"CRTsp"} object are removed.
Other data are unchanged.
}
\examples{
#Rotate and reflect test site locations
transformedTestlocations <- anonymize_site(trial =  readdata("exampleCRT.txt"))
}
