% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CScompare.R
\name{CScompare}
\alias{CScompare}
\title{Compare CS Results.}
\usage{
CScompare(CSresult1, CSresult2, component1.plot, component2.plot,
  threshold.pvalues = 0.05, which = c(1, 2, 3), color.columns = NULL,
  gene.thresP = NULL, gene.thresN = NULL, thresP.col = c("blue",
  "light blue"), thresN.col = c("red", "pink"), legend.names = NULL,
  legend.cols = NULL, legend.pos = "topright", plot.type = "device",
  basefilename = NULL)
}
\arguments{
\item{CSresult1}{First result.}

\item{CSresult2}{Second result.}

\item{component1.plot}{If you are using a non-Zhang&Gant result, specify the bicluster, factor or principal component which should be used to derive connectivity scores from for the \emph{first} result.}

\item{component2.plot}{If you are using a non-Zhang&Gant result, specify the bicluster, factor or principal component which should be used to derive connectivity scores from for the \emph{second} result.}

\item{threshold.pvalues}{If both CSresult1 and CSresult contain pvalues (and adjusted pvalues), this threshold will be used to compare the number of overlapping significant results.}

\item{which}{Choose one or both plots which should be created.
\enumerate{
\item CS Comparison Plot
\item GS Comparison Plot
\item CSRankScores (Normal CS for CSzhang) Comparison Plot
\item CS p-values comparison plot (Raw & Adjusted).
\item CRankScores p-values comparison plot (Raw & Adjusted).
}}

\item{color.columns}{Vector of colors for the reference and query columns (compounds). If \code{NULL}, blue will be used for reference and black for query. Use this option to highlight reference columns and query columns of interest.}

\item{gene.thresP}{Vector of length 2 containing the positive gene thresholds for \code{CSresult1} and \code{CSresult2}. Genes above the threshold will be colored. (e.g. \code{c(1,2)})}

\item{gene.thresN}{Vector of length 2 containing the negative gene thresholds for \code{CSresult1} and \code{CSresult2}. Genes below the threshold will be colored. (e.g. \code{c(-1,-2)})}

\item{thresP.col}{Vector of length 2 containing the colors for the high gene scores for \code{CSresult1} and \code{CSresult2} (e.g. \code{c("blue","light blue")}).}

\item{thresN.col}{Vector of length 2 containing the colors for the low gene scores for \code{CSresult1} and \code{CSresult2} (e.g. \code{c("red","pink")}).}

\item{legend.names}{Option to draw a legend (about the highlights in \code{color.columns}) in the CS plot. If \code{NULL}, only references are in the legend.}

\item{legend.cols}{Colors to be used for the \code{legend.names}.}

\item{legend.pos}{The location of the legend: \code{"bottomright"}, \code{"bottom"}, \code{"bottomleft"}, \code{"left"}, \code{"topleft"}, \code{"top"}, \code{"topright"}, \code{"right"} and \code{"center"}.}

\item{plot.type}{How should the plots be outputted? \code{"pdf"} to save them in pdf files, \code{device} to draw them in a graphics device (default), \code{sweave} to use them in a sweave or knitr file.}

\item{basefilename}{Directory including filename of the graphs if saved in pdf files}
}
\value{
A list object with 2 slots. In the first slot, Pearson and Spearman correlation between the results (CLoadings, Gene Scores, CRanking Scores, (adjusted) p-values) can be found. The second slot, if permutation was applied, contains a small comparison between the significant results based on \code{threshold.pvalues}.
}
\description{
After applying different CSanalysis on the same data, you can compare 2 different results of connectivity loadings, connectivity ranking scores and gene scores
Unless the result came from a Zhang and Gant analysis, you choose from which component (factor, PC, bicluster) the scores should be derived.
Further, for Zhang and Gant analysis, the "CRanking Scores" and "CLoadings" will be the same as the ZG Score as well as the p-values.
}
\examples{
data("dataSIM",package="CSFA")
Mat1 <- dataSIM[,c(1:6)]
Mat2 <- dataSIM[,-c(1:6)]

MFA_analysis <- CSanalysis(Mat1,Mat2,"CSmfa",component.plot=1)
ZHANG_analysis <- CSanalysis(Mat1,Mat2,"CSzhang")

CScompare(MFA_analysis,ZHANG_analysis,1)
}
