% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_BiasCorrection.R
\name{BiasCorrection}
\alias{BiasCorrection}
\title{Bias Correction based on the mean and standard deviation adjustment}
\usage{
BiasCorrection(exp, obs, exp_cor = NULL, na.rm = FALSE)
}
\arguments{
\item{exp}{a multidimensional array with named dimensions containing the seasonal forecast experiment data with at least 'member' and 'sdate' dimensions.}

\item{obs}{a multidimensional array with named dimensions containing the observed data with at least 'sdate' dimension.}

\item{exp_cor}{a multidimensional array with named dimensions containing the seasonl forecast experiment to be corrected. If it is NULL, the 'exp' forecast will be corrected.}

\item{na.rm}{a logical value indicating whether missing values should be stripped before the computation proceeds, by default it is set to FALSE.}
}
\value{
an object of class \code{s2dv_cube} containing the bias corrected forecasts in the element called \code{$data} with the same dimensions of the experimental data.
}
\description{
This function applies the simple bias adjustment technique described in Torralba et al. (2017). The adjusted forecasts have an equivalent standard deviation and mean to that of the reference dataset.
}
\examples{

# Example
# Creation of sample s2dverification objects. These are not complete
# s2dverification objects though. The Load function returns complete objects.
mod1 <- 1 : (1 * 3 * 4 * 5 * 6 * 7)
dim(mod1) <- c(dataset = 1, member = 3, sdate = 4, ftime = 5, lat = 6, lon = 7)
obs1 <- 1 : (1 * 1 * 4 * 5 * 6 * 7)
dim(obs1) <- c(dataset = 1, member = 1, sdate = 4, ftime = 5, lat = 6, lon = 7)
a <- BiasCorrection(exp = mod1, obs = obs1)
str(a)
}
\references{
Torralba, V., F.J. Doblas-Reyes, D. MacLeod, I. Christel and M. Davis (2017). Seasonal climate prediction: a new source of information for the management of wind energy resources. Journal of Applied Meteorology and Climatology, 56, 1231-1247, doi:10.1175/JAMC-D-16-0204.1. (CLIM4ENERGY, EUPORIAS, NEWA, RESILIENCE, SPECS)
}
\author{
Verónica Torralba, \email{veronica.torralba@bsc.es}
}
