% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.diffusionSnapShot.r
\name{graph.diffusionSnapShot}
\alias{graph.diffusionSnapShot}
\title{Capture the current state of probability diffusion}
\usage{
graph.diffusionSnapShot(adj_mat,G,output_dir,p1,startNode,
                                visitedNodes,recursion_level,coords)
}
\arguments{
\item{adj_mat}{- The adjacency matrix that encodes the edge weights for
the network, G.}

\item{G}{- A list of probabilities, with names of the list being the node
names in the network.}

\item{output_dir}{- The local directory at which you want still PNG images
to be saved.}

\item{p1}{- The probability being dispersed from the starting node,
startNode, which is preferentially distributed between network
nodes by the probability diffusion algorithm based solely on
network connectivity.}

\item{startNode}{- The first variable drawn in the node ranking, from
which p1 gets dispersed.}

\item{visitedNodes}{- A character vector of node names, storing the
history of previous draws in the node ranking.}

\item{recursion_level}{- The current depth in the call stack caused by
a recursive algorithm.}

\item{coords}{- The x and y coordinates for each node in the network, to
remain static between images.}
}
\value{
0
}
\description{
Recursively diffuse probability from a starting node based on the
connectivity in a network, G, where the probability represents the
likelihood that a variable will be influenced by a perturbation
in the starting node.
}
\examples{
# 7 node example graph illustrating diffusion of probability based on
# network connectivity.
adj_mat = rbind(c(0,2,1,0,0,0,0), # A
                c(2,0,1,0,0,0,0), # B
                c(1,0,0,1,0,0,0), # C
                c(0,0,1,0,2,0,0), # D
                c(0,0,0,2,0,2,1), # E
                c(0,0,0,1,2,0,1), # F
                c(0,0,0,0,1,1,0)  # G
                )
rownames(adj_mat) = c("A", "B", "C", "D", "E", "F", "G")
colnames(adj_mat) = c("A", "B", "C", "D", "E", "F", "G")
ig = graph.adjacency(as.matrix(adj_mat),mode="undirected",weighted=TRUE)
G=vector(mode="list", length=7)
G[seq_len(length(G))] = 0
names(G) = c("A", "B", "C", "D", "E", "F", "G")
coords = layout.fruchterman.reingold(ig)
V(ig)$x = coords[,1]
V(ig)$y = coords[,2]
# Uncomment to run
#graph.diffusionSnapShot(adj_mat,G,getwd(),1.0,"A","A",1,coords)
}
