% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.zscoreData.r
\name{data.zscoreData}
\alias{data.zscoreData}
\title{Z-transform available data}
\usage{
data.zscoreData(data, ref)
}
\arguments{
\item{data}{- Normalized, imputed data. Data matrix includes 
features as rows, samples as columns.}

\item{ref}{- Normalized, imputed reference sample data. Data
includes features as rows, samples as columns.}
}
\value{
zscored.data - Z-transformed data.
}
\description{
The z-transform is meant to work with normalized,
imputed metabolomics data
}
\examples{
dis_data = matrix(rexp(500), ncol=100)
rownames(dis_data)=sprintf("Feature\%d",seq_len(nrow(dis_data)))
colnames(dis_data)=sprintf("Sample\%d",seq_len(ncol(dis_data)))
ref_data = matrix(rexp(500), ncol=100)
rownames(ref_data)=sprintf("Feature\%d",seq_len(nrow(ref_data)))
colnames(ref_data)=sprintf("Sample\%d",seq_len(ncol(ref_data)))
zscored.data=data.zscoreData(dis_data,ref_data)
}
