% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varmatCUBE.R
\name{varmatCUBE}
\alias{varmatCUBE}
\title{Variance-covariance matrix for CUBE models}
\usage{
varmatCUBE(ordinal,m,param,Y=0,W=0,Z=0,expinform=FALSE)
}
\arguments{
\item{ordinal}{Vector of ordinal responses}

\item{m}{Number of ordinal categories}

\item{param}{Vector of parameters for the specified CUBE model}

\item{Y}{Matrix of selected covariates to explain the uncertainty component (default: no covariate is included 
in the model)}

\item{W}{Matrix of selected covariates to explain the feeling component (default: no covariate is included 
in the model)}

\item{Z}{Matrix of selected covariates to explain the overdispersion component (default: no covariate is included 
in the model)}

\item{expinform}{Logical: if TRUE  and no covariate is included in the model, the function returns
the expected variance-covariance matrix (default is FALSE: the function returns the observed 
variance-covariance matrix)}
}
\description{
Compute the variance-covariance matrix of parameter estimates for CUBE models when no covariate
is specified, or when covariates are included for all the three parameters.
}
\details{
The function checks if the variance-covariance matrix is positive-definite: if not, 
it returns a warning message and produces a matrix with NA entries.
}
\examples{
m<-7; n<-500;
pai<-0.83; csi<-0.19; phi<-0.045;
ordinal<-simcube(n,m,pai,csi,phi)
param<-c(pai,csi,phi)
varmat<-varmatCUBE(ordinal,m,param)
##########################
### Including covariates
\donttest{
data(relgoods)
m<-10
ordinal<-relgoods[,37]
age<-2014-relgoods[,4]
lage<-log(age)-mean(log(age))
nona<-na.omit(cbind(ordinal,lage))
ordinal<-nona[,1]
Y<-W<-Z<-nona[,2]
estbet<-c(0.18, 1.03); estgama<-c(-0.6, -0.3); estalpha<-c(-2.3,0.92);
param<-c(estbet,estgama,estalpha);
varmat<-varmatCUBE(ordinal, m, param, Y=Y, W=W, Z=Z, expinform=TRUE)
}
}
\references{
Iannario, M. (2014). Modelling Uncertainty and Overdispersion in Ordinal Data, 
\emph{Communications in Statistics - Theory and Methods}, \bold{43}, 771--786 \cr
Piccolo, D. (2014). Inferential issues on CUBE models with covariates, 
\emph{Communications in Statistics - Theory and Methods}, \bold{44}, DOI: 10.1080/03610926.2013.821487
}
\seealso{
\code{\link{CUBE}}, \code{\link{loglikCUBE}}
}
\keyword{htest}

