% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube000.R
\name{cube000}
\alias{cube000}
\title{Main function for CUBE models without covariates}
\usage{
cube000(m, ordinal, starting, maxiter, toler, expinform)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{starting}{Vector of initial estimates to start the optimization algorithm, 
whose length equals the number of parameters of the model}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm}

\item{toler}{Fixed error tolerance for final estimates}

\item{expinform}{Logical: if TRUE, the function returns the expected variance-covariance matrix}
}
\value{
An object of the class "CUBE"
}
\description{
Estimate and validate a CUBE model without covariates.
}
\references{
Iannario, M. (2014). Modelling Uncertainty and Overdispersion in Ordinal Data,
  \emph{Communications in Statistics - Theory and Methods}, \bold{43}, 771--786 \cr
Iannario, M. (2015). Detecting latent components in ordinal data with overdispersion by means 
of a mixture distribution, \emph{Quality & Quantity}, \bold{49}, 977--987
}
\keyword{#models}
\keyword{internal}
