% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myfunctions.R
\name{CVR}
\alias{CVR}
\title{Fit canonical variate regression with tuning parameters selected by cross validation.}
\usage{
CVR(Y, Xlist, rankseq = 2, neta = 10, etaseq = NULL, nlam = 50, 
     Lamseq = NULL, family = c("gaussian", "binomial", "poisson"),  
     Wini = NULL, penalty = c("GL1", "L1"), nfold = 10, foldid = NULL,  
     opts = list(), type.measure = NULL)
}
\arguments{
\item{Y}{A univariate response variable.}

\item{Xlist}{A list of two covariate matrices as in \code{cvrsolver}.}

\item{rankseq}{A sequence of candidate ranks. The default is a single value 2.}

\item{neta}{Number of \eqn{\eta} values. The default is 10.}

\item{etaseq}{A sequence of  length \code{neta} containing candidate \eqn{\eta} values between 0 and 1. 
The default is 10^seq(-2, log10(0.9), length = neta).}

\item{nlam}{Number of  \eqn{\lambda} values. The default is 50.}

\item{Lamseq}{A matrix of   \eqn{\lambda}  values. The column number is the number of sets in \code{Xlist},
and the row number is \code{nlam}. The default is 10^(seq(-2, 2, length = nlam)) for each column.}

\item{family}{Type of response as in \code{cvrsolver}. The default is \code{"gaussian"}.}

\item{Wini}{A list of initial loading W's. The default is from the SparseCCA solution. See \code{SparseCCA}.}

\item{penalty}{Type of penalty on loading matrices W's as in \code{cvrsolver}. The default is \code{"GL1"}.}

\item{nfold}{Number of folds in cross validation. The default is 10.}

\item{foldid}{Specifying training and testing sets in cross validation; random generated if not supplied. 
It remains the same across different rank and \eqn{\eta}.}

\item{opts}{A list of options for controlling the algorithm. The default of \code{opts$spthresh} is 0.4, which means 
we only search sparse models with at most 40\% nonzero entries in W1 and W2. See the other options 
(\code{standardization}, \code{maxIters} and \code{tol}) in \code{cvrsolver}.}

\item{type.measure}{Type of measurement used in cross validation. \code{"mse"} for Gaussian, \code{"auc"} for binomial,
and \code{"deviance"} for binomial and Poisson.}
}
\value{
An object with S3 class "CVR" containing the following components

\item{cverror}{A matrix containing the CV errors. The number of rows is the length 
                   of \code{etaseq} and the number of columns is the length of \code{rankseq}.}

\item{etahat}{Selected \eqn{\eta}.}

\item{rankhat}{Selected rank.}

\item{Lamhat}{Selected  \eqn{\lambda}'s.}

\item{Alphapath}{An array containing  the fitted paths of the intercept term \eqn{\alpha}.}

\item{Betapath}{An array containing the fitted paths of the regression coefficient \eqn{\beta}.}

\item{W1path, W2path}{Arrays containing the fitted paths of  W1 and W2.}

\item{foldid}{\code{foldid} used in cross validation.}

\item{cvout}{Cross validation results using selected \eqn{\eta} and rank.}

\item{solution}{A list including the solutions of \eqn{\alpha}, \eqn{\beta}, W1 and W2, by refitting all the data 
                       using selected tuning parameters.}
}
\description{
This function fits the solution path of canonical variate regression, 
     with tuning parameters selected by  cross validation. The tuning parameters 
     include the rank, the  \eqn{\eta} and the \eqn{\lambda}.
}
\details{
In this function, the rank, \eqn{\eta} and \eqn{\lambda} are tuned by  cross validation. CVR then is refitted with
           all  data using  the selected tuning parameters.  The \code{plot} function  shows the tuning of  \eqn{\lambda}, 
           with selected rank and \eqn{\eta}.
}
\examples{
############## Gaussian response ###################### 
set.seed(42)   
mydata <- SimulateCVR(family = "g", n = 100, rank = 4, p1 = 50, p2 = 70,  
                  pnz = 10, beta = c(2, 1, 0, 0))
X1 <- mydata$X1;
X2 <- mydata$X2
Xlist <- list(X1 = X1, X2 = X2); 
Y <- mydata$y
## fix rank = 4, tune eta and lambda   
##out_cvr <- CVR(Y, Xlist, rankseq = 4, neta = 5, nlam = 25,  
##               family = "g", nfold = 5)
## out_cvr$solution$W[[1]];  
## out_cvr$solution$W[[2]];     
### uncomment to see plots 
## plot.CVR(out_cvr)
## 
## Distance of subspaces 
##U <- mydata$U
##Pj <- function(U) U \%*\% solve(t(U) \%*\% U, t(U)) 
##sum((Pj(U) - (Pj(X1 \%*\% out_cvr$sol$W[[1]]) + Pj(X2 \%*\% out_cvr$sol$W[[2]]))/2)^2) 
## Precision/Recall rate
## the first 10 rows of the true W1 and W2 are set to be nonzero
##W12 <- rbind(out_cvr$sol$W[[1]], out_cvr$sol$W[[1]])
##W12norm <- apply(W12, 1, function(a)sqrt(sum(a^2)))
##prec <- sum(W12norm[c(1:10, 51:60)] != 0)/sum(W12norm != 0); prec 
##rec <- sum(W12norm[c(1:10, 51:60)] != 0)/20; rec
## sequential SparseCCA, compare the Distance of subspaces and Prec/Rec
##W12s <- SparseCCA(X1, X2, 4)
## Distance larger than CVR's 
##sum((Pj(U) - (Pj(X1 \%*\% W12s$W1) + Pj(X2 \%*\% W12s$W2))/2)^2) 
##W12snorm <- apply(rbind(W12s$W1, W12s$W2), 1, function(a)sqrt(sum(a^2)))
## compare Prec/Rec 
##sum(W12snorm[c(1:10, 51:60)] != 0)/sum(W12snorm != 0);  
##sum(W12snorm[c(1:10, 51:60)] != 0)/20; 

############## binary response ########################
set.seed(12) 
mydata <- SimulateCVR(family = "binomial", n = 300, rank = 4, p1 = 50,  
                       p2 = 70, pnz = 10, beta = c(2, 1, 0, 0))
X1 <- mydata$X1; X2 <- mydata$X2
Xlist <- list(X1 = X1, X2 = X2); 
Y <- mydata$y
## out_cvr <- CVR(Y, Xlist, 4, neta = 5, nlam=25, family = "b", nfold = 5)  
## out_cvr$sol$W[[1]];  
## out_cvr$sol$W[[2]];    
## plot.CVR(out_cvr)

############## Poisson response ######################
set.seed(34)
mydata <- SimulateCVR(family = "p", n = 100, rank = 4, p1 = 50,    
                       p2 = 70, pnz = 10, beta = c(0.2, 0.1, 0, 0))
X1 <- mydata$X1; X2 <- mydata$X2
Xlist <- list(X1 = X1, X2 = X2); 
Y <- mydata$y
## etaseq <- 10^seq(-3, log10(0.95), len = 10)
## out_cvr <- CVR(Y, Xlist, 4, neta = 5, nlam = 25, family = "p", nfold = 5)
## out_cvr$sol$W[[1]];  
## out_cvr$sol$W[[2]];    
## plot.CVR(out_cvr)  
}
\references{
Chongliang Luo, Jin Liu, Dipak D. Dey and Kun Chen (2016) Canonical variate regression. 
               Biostatistics, doi: 10.1093/biostatistics/kxw001.
}
\seealso{
\code{\link{cvrsolver}}, \code{\link{SparseCCA}}, \code{\link{SimulateCVR}}.
}
\author{
Chongliang Luo, Kun Chen.
}
