% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\docType{methods}
\name{curvature}
\alias{curvature}
\title{Curvature of Expression}
\usage{
curvature(object)
}
\arguments{
\item{object}{An \linkS4class{Expression} object.}
}
\value{
A string indicating the curvature of the expression, either "CONSTANT", "AFFINE", "CONVEX, "CONCAVE", or "UNKNOWN".
}
\description{
The curvature of an expression.
}
\examples{
x <- Variable()
c <- Constant(5)

curvature(c)
curvature(x)
curvature(x^2)
curvature(sqrt(x))
curvature(log(x^3) + sqrt(x))
}
