% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementwise.R
\docType{class}
\name{Entr-class}
\alias{Entr-class}
\alias{.Entr}
\alias{Entr}
\alias{to_numeric,Entr-method}
\alias{sign_from_args,Entr-method}
\alias{is_atom_convex,Entr-method}
\alias{is_atom_concave,Entr-method}
\alias{is_incr,Entr-method}
\alias{is_decr,Entr-method}
\alias{.grad,Entr-method}
\alias{.domain,Entr-method}
\title{The Entr class.}
\usage{
Entr(x)

\S4method{to_numeric}{Entr}(object, values)

\S4method{sign_from_args}{Entr}(object)

\S4method{is_atom_convex}{Entr}(object)

\S4method{is_atom_concave}{Entr}(object)

\S4method{is_incr}{Entr}(object, idx)

\S4method{is_decr}{Entr}(object, idx)

\S4method{.grad}{Entr}(object, values)

\S4method{.domain}{Entr}(object)
}
\arguments{
\item{x}{An \linkS4class{Expression} or numeric constant.}

\item{object}{An \linkS4class{Entr} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}
}
\description{
This class represents the elementwise operation \eqn{-xlog(x)}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric(Entr)}: The elementwise entropy function evaluated at the value.

\item \code{sign_from_args(Entr)}: The sign of the atom is unknown.

\item \code{is_atom_convex(Entr)}: The atom is not convex.

\item \code{is_atom_concave(Entr)}: The atom is concave.

\item \code{is_incr(Entr)}: The atom is weakly increasing.

\item \code{is_decr(Entr)}: The atom is weakly decreasing.

\item \code{.grad(Entr)}: Gives the (sub/super)gradient of the atom w.r.t. each variable

\item \code{.domain(Entr)}: Returns constraints descrbing the domain of the node

}}
\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} or numeric constant.}
}}

