% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{PfEigenvalue-class}
\alias{PfEigenvalue-class}
\alias{.PfEigenvalue}
\alias{PfEigenvalue}
\alias{name,PfEigenvalue-method}
\alias{to_numeric,PfEigenvalue-method}
\alias{dim_from_args,PfEigenvalue-method}
\alias{sign_from_args,PfEigenvalue-method}
\alias{is_atom_convex,PfEigenvalue-method}
\alias{is_atom_concave,PfEigenvalue-method}
\alias{is_atom_log_log_convex,PfEigenvalue-method}
\alias{is_atom_log_log_concave,PfEigenvalue-method}
\alias{is_incr,PfEigenvalue-method}
\alias{is_decr,PfEigenvalue-method}
\alias{.grad,PfEigenvalue-method}
\title{The PfEigenvalue class.}
\usage{
PfEigenvalue(X)

\S4method{name}{PfEigenvalue}(x)

\S4method{to_numeric}{PfEigenvalue}(object, values)

\S4method{dim_from_args}{PfEigenvalue}(object)

\S4method{sign_from_args}{PfEigenvalue}(object)

\S4method{is_atom_convex}{PfEigenvalue}(object)

\S4method{is_atom_concave}{PfEigenvalue}(object)

\S4method{is_atom_log_log_convex}{PfEigenvalue}(object)

\S4method{is_atom_log_log_concave}{PfEigenvalue}(object)

\S4method{is_incr}{PfEigenvalue}(object, idx)

\S4method{is_decr}{PfEigenvalue}(object, idx)

\S4method{.grad}{PfEigenvalue}(object, values)
}
\arguments{
\item{X}{An \linkS4class{Expression} or numeric matrix.}

\item{x, object}{A \linkS4class{PfEigenvalue} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}
}
\description{
This class represents the Perron-Frobenius eigenvalue of a positive matrix.
}
\section{Methods (by generic)}{
\itemize{
\item \code{name(PfEigenvalue)}: The name and arguments of the atom.

\item \code{to_numeric(PfEigenvalue)}: Returns the Perron-Frobenius eigenvalue of \code{X}.

\item \code{dim_from_args(PfEigenvalue)}: The dimensions of the atom.

\item \code{sign_from_args(PfEigenvalue)}: Returns the sign (is positive, is negative) of the atom.

\item \code{is_atom_convex(PfEigenvalue)}: Is the atom convex?

\item \code{is_atom_concave(PfEigenvalue)}: Is the atom concave?

\item \code{is_atom_log_log_convex(PfEigenvalue)}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave(PfEigenvalue)}: Is the atom log-log concave?

\item \code{is_incr(PfEigenvalue)}: Is the atom weakly increasing in the argument \code{idx}?

\item \code{is_decr(PfEigenvalue)}: Is the atom weakly decreasing in the argument \code{idx}?

\item \code{.grad(PfEigenvalue)}: Gives the (sub/super)gradient of the atom w.r.t. each variable

}}
\section{Slots}{

\describe{
\item{\code{X}}{An \linkS4class{Expression} or numeric matrix.}
}}

