% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{LogSumExp-class}
\alias{LogSumExp-class}
\alias{.LogSumExp}
\alias{LogSumExp}
\alias{to_numeric,LogSumExp-method}
\alias{.grad,LogSumExp-method}
\alias{.column_grad,LogSumExp-method}
\alias{sign_from_args,LogSumExp-method}
\alias{is_atom_convex,LogSumExp-method}
\alias{is_atom_concave,LogSumExp-method}
\alias{is_incr,LogSumExp-method}
\alias{is_decr,LogSumExp-method}
\title{The LogSumExp class.}
\usage{
LogSumExp(x, axis = NA_real_, keepdims = FALSE)

\S4method{to_numeric}{LogSumExp}(object, values)

\S4method{.grad}{LogSumExp}(object, values)

\S4method{.column_grad}{LogSumExp}(object, value)

\S4method{sign_from_args}{LogSumExp}(object)

\S4method{is_atom_convex}{LogSumExp}(object)

\S4method{is_atom_concave}{LogSumExp}(object)

\S4method{is_incr}{LogSumExp}(object, idx)

\S4method{is_decr}{LogSumExp}(object, idx)
}
\arguments{
\item{x}{An \linkS4class{Expression} representing a vector or matrix.}

\item{axis}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}

\item{keepdims}{(Optional) Should dimensions be maintained when applying the atom along an axis? If \code{FALSE}, result will be collapsed into an \eqn{n x 1} column vector. The default is \code{FALSE}.}

\item{object}{A \linkS4class{LogSumExp} object.}

\item{values}{A list of numeric values.}

\item{value}{A numeric value.}

\item{idx}{An index into the atom.}
}
\description{
The natural logarithm of the sum of the elementwise exponential, \eqn{\log\sum_{i=1}^n e^{x_i}}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: Evaluates \eqn{e^x} elementwise, sums, and takes the natural log.

\item \code{.grad}: Gives the (sub/super)gradient of the atom w.r.t. each variable

\item \code{.column_grad}: Gives the (sub/super)gradient of the atom w.r.t. each column variable.

\item \code{sign_from_args}: Returns sign (is positive, is negative) of the atom.

\item \code{is_atom_convex}: The atom is convex.

\item \code{is_atom_concave}: The atom is not concave.

\item \code{is_incr}: The atom is weakly increasing in the index.

\item \code{is_decr}: The atom is not weakly decreasing in the index.
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} representing a vector or matrix.}

\item{\code{axis}}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}

\item{\code{keepdims}}{(Optional) Should dimensions be maintained when applying the atom along an axis? If \code{FALSE}, result will be collapsed into an \eqn{n x 1} column vector. The default is \code{FALSE}.}
}}

