% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BatchCorrection.R
\name{CorrectBatches}
\alias{CorrectBatches}
\title{CorrectBatches}
\usage{
CorrectBatches(
  lsBatches,
  hierarchical = TRUE,
  queNumCelltypes = NULL,
  maxMem = 5,
  sampling = FALSE,
  numSamples = NULL,
  kNN = 30,
  pcaDim = 50,
  pairsFilter = FALSE,
  perCellMNN = 0.08,
  fuzzy = TRUE,
  fuzzyPCA = 10,
  estMethod = "Median",
  clusterMethod = "louvain",
  doCosNorm = FALSE,
  fracSampling = NULL,
  debug = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{lsBatches}{List of batches to integrate. Batches should contain the same number of genes as rows.}

\item{hierarchical}{Use hierarchical integration scheme when correcting more than two batches.
If set to FALSE, the input batches are sorted by number of cells and integrated on descending order.}

\item{queNumCelltypes}{Number of cell types in the query batch. By default Canek searches the number of
cell types using an heuristic algorithm. Change this parameter if you know the number of cell types in advanced.}

\item{maxMem}{Maximum number of memberships from the query batch. This parameter is used on the heuristic algorithm to find the number of cell types.}

\item{sampling}{Use MNNs pairs sampling when using a Kalman filter to estimate the correction vector.}

\item{numSamples}{If sampling. Number of MNNs pairs samples to use on the estimation process.}

\item{kNN}{Number of k-nearest-neighbors used to define the MNNs pairs.}

\item{pcaDim}{Number of PCA dimensions to use.}

\item{pairsFilter}{Filter MNNs pairs before estimating the correction vectors. If TRUE,
the pairs are filtered from outliers using an interquartile range method.}

\item{perCellMNN}{Threshold value to decide if a membership's correction value is calculated.
As a rough interpretation, this values can be thought as the proportion of cells from a membership
with an associated MNN pair. If the proportion is low, an specific correction vectors is
not calculated for this membership.}

\item{fuzzy}{Use fuzzy logic to join the local correction vectors.}

\item{fuzzyPCA}{Number of PCs to use in the fuzzy process.}

\item{estMethod}{Method to use when estimating the correction vectors:
\itemize{
  \item{Median. Use the cells median distance}
  \item{EKF. Use an extended Kalman filter}
}}

\item{clusterMethod}{Method used to identify memberships.}

\item{doCosNorm}{Whether to do cosine normalization.}

\item{fracSampling}{Fraction of cells to sample in the hierarchical selection (default is NULL, no sampling).}

\item{debug}{Return correction's information}

\item{verbose}{Print output.}

\item{...}{Pass down methods from RunCanek().}
}
\value{
A list containing the integrated datasets as matrix and the correction data .
}
\description{
Batch-effect correction over a list of single cell batches
}
\details{
CorrectBatches is a method to correct batch-effect from two or more single-cell batches.
Batch-effects observations are defined using mutual nearest neighbors (MNNs) pairs and cell
groups from the query batch are distinguished using clustering. We estimate a correction vector
for each cluster using its MNNs pairs and use these vectors to remove the batch effect from the query batch in two ways:
\itemize{
   \item{A linear correction is performed by equally correcting the cells from the same cluster.}
   \item{A non-linear correction is performed by differently correcting each cell using fuzzy logic.}
}
}
\examples{
Batches <- SimBatches$batches
z <- CorrectBatches(Batches)

Uncorrected_PCA <- prcomp(t(cbind(Batches[[1]], Batches[[2]])))
plot(Uncorrected_PCA$x[,1:2])
Corrected_PCA <- prcomp(t(z))
plot(Corrected_PCA$x[,1:2])

}
