% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{cutoff,network-method}
\alias{cutoff,network-method}
\alias{cutoff}
\alias{cutoff-methods}
\title{Choose the best cutoff}
\usage{
\S4method{cutoff}{network}(Omega, sequence = NULL, x_min = 0)
}
\arguments{
\item{Omega}{a network object}

\item{sequence}{(optional) a vector corresponding to the sequence of cutoffs 
that will be tested.}

\item{x_min}{(optional) an integer ; only values over x_min are further 
retained for performing the test.}
}
\value{
A list containing two objects : \item{p.value}{the p values
corresponding to the sequence of cutoff} \item{p.value.inter}{the smoothed p
value vector, using the loess function}
}
\description{
Allows estimating the best cutoff, in function of the scale-freeness of the
network.  For a sequence of cutoff, the corresponding p-value is then
calculated.
}
\examples{

\donttest{
	data(network)
	cutoff(network)
	#See vignette for more details
}

}
\references{
Jung, N., Bertrand, F., Bahram, S., Vallat, L., and
Maumy-Bertrand, M. (2014). Cascade: a R-package to study, predict and
simulate the diffusion of a signal through a temporal gene network.
\emph{Bioinformatics}, btt705.

Vallat, L., Kemper, C. A., Jung, N., Maumy-Bertrand, M., Bertrand, F.,
Meyer, N., ... & Bahram, S. (2013). Reverse-engineering the genetic
circuitry of a cancer cell with predicted intervention in chronic
lymphocytic leukemia. \emph{Proceedings of the National Academy of
Sciences}, 110(2), 459-464.
}
\author{
Nicolas Jung, Frédéric Bertrand , Myriam Maumy-Bertrand.
}
\keyword{methods}
