plot.CatDynData <-
function(x,tstep,mult,unit1,unit2,bmunit,span,top.text,hem,...)
    {
     options(warn=-1)
     par(mfrow=c(3,2),oma=c(2,2,2,1), mar=c(4,4,2,2))
     plot(x=x$obseff1,y=x$obscat,main="",xlab=paste("Effort (",unit1,")",sep=""),ylab=paste("Catch (",mult,")",sep=""))
     plot(x=x$obseff2,y=x$obscat,main="",xlab=paste("Effort (",unit2,")",sep=""),ylab=paste("Catch (",mult,")",sep=""))
     plot(x=x$period,y=x$obseff1,xlab=tstep,ylab=paste("Effort (",unit1,")",sep=""),axes=FALSE)
     axis(side=1,at=seq(head(x$period,1),tail(x$period,1),1))
     axis(side=2,at=NULL)
     obseff1.trend    <- loess(x$obseff1~x$period,span=span)
     obseff1.pred     <- predict(obseff1.trend)
     lines(x=x$period,y=obseff1.pred,col="blue",lwd=1)
     if(hem=="N")
       {
       if(tstep=="Week")
         {
         text(x=12+2,y=0.9*max(x$obseff1),lab="Spring",col='blue')
         text(x=25+2,y=0.9*max(x$obseff1),lab="Summer",col='blue')
         text(x=38+2,y=0.9*max(x$obseff1),lab="Fall",col='blue')
         text(x=51+2,y=0.9*max(x$obseff1),lab="Winter",col='blue')
         abline(v=12,col='blue')
         abline(v=25,col='blue')
         abline(v=38,col='blue')
         abline(v=51,col='blue')
         }
       else
         {
         text(x=079+10,y=0.9*max(x$obseff1),lab="Spring",col='blue')
         text(x=171+10,y=0.9*max(x$obseff1),lab="Summer",col='blue')
         text(x=263+10,y=0.9*max(x$obseff1),lab="Fall",col='blue')
         text(x=354+10,y=0.9*max(x$obseff1),lab="Winter",col='blue')
         abline(v=079,col='blue')
         abline(v=171,col='blue')
         abline(v=263,col='blue')
         abline(v=354,col='blue')
         }
       }
     else
       {
       if(tstep=="Week")
         {
         text(x=12+2,y=0.9*max(x$obseff1),lab="Fall",col='blue')
         text(x=25+2,y=0.9*max(x$obseff1),lab="Winter",col='blue')
         text(x=38+2,y=0.9*max(x$obseff1),lab="Spring",col='blue')
         text(x=51+2,y=0.9*max(x$obseff1),lab="Summer",col='blue')
         abline(v=12,col='blue')
         abline(v=25,col='blue')
         abline(v=38,col='blue')
         abline(v=51,col='blue')
         }
       else
         {
         text(x=079+10,y=0.9*max(x$obseff1),lab="Fall",col='blue')
         text(x=171+10,y=0.9*max(x$obseff1),lab="Winter",col='blue')
         text(x=263+10,y=0.9*max(x$obseff1),lab="Spring",col='blue')
         text(x=354+10,y=0.9*max(x$obseff1),lab="Summer",col='blue')
         abline(v=079,col='blue')
         abline(v=171,col='blue')
         abline(v=263,col='blue')
         abline(v=354,col='blue')
         }
       }
     plot(x=x$period,y=x$obseff2,xlab=tstep,ylab=paste("Effort (",unit2,")",sep=""),axes=FALSE)
     axis(side=1,at=seq(head(x$period,1),tail(x$period,1),1))
     axis(side=2,at=NULL)
     obseff2.trend    <- loess(x$obseff2~x$period,span=span)
     obseff2.pred     <- predict(obseff2.trend)
     lines(x$period,obseff2.pred,col="blue",lwd=1)
     if(hem=="N")
       {
       if(tstep=="Week")
         {
         text(x=12+2,y=0.9*max(x$obseff2),lab="Spring",col='blue')
         text(x=25+2,y=0.9*max(x$obseff2),lab="Summer",col='blue')
         text(x=38+2,y=0.9*max(x$obseff2),lab="Fall",col='blue')
         text(x=51+2,y=0.9*max(x$obseff2),lab="Winter",col='blue')
         abline(v=12,col='blue')
         abline(v=25,col='blue')
         abline(v=38,col='blue')
         abline(v=51,col='blue')
         }
       else
         {
         text(x=079+10,y=0.9*max(x$obseff2),lab="Spring",col='blue')
         text(x=171+10,y=0.9*max(x$obseff2),lab="Summer",col='blue')
         text(x=263+10,y=0.9*max(x$obseff2),lab="Fall",col='blue')
         text(x=354+10,y=0.9*max(x$obseff2),lab="Winter",col='blue')
         abline(v=079,col='blue')
         abline(v=171,col='blue')
         abline(v=263,col='blue')
         abline(v=354,col='blue')
         }
       }
     else
       {
       if(tstep=="Week")
         {
         text(x=12+2,y=0.9*max(x$obseff2),lab="Fall",col='blue')
         text(x=25+2,y=0.9*max(x$obseff2),lab="Winter",col='blue')
         text(x=38+2,y=0.9*max(x$obseff2),lab="Spring",col='blue')
         text(x=51+2,y=0.9*max(x$obseff2),lab="Summer",col='blue')
         abline(v=12,col='blue')
         abline(v=25,col='blue')
         abline(v=38,col='blue')
         abline(v=51,col='blue')
         }
       else
         {
         text(x=079+10,y=0.9*max(x$obseff2),lab="Fall",col='blue')
         text(x=171+10,y=0.9*max(x$obseff2),lab="Winter",col='blue')
         text(x=263+10,y=0.9*max(x$obseff2),lab="Spring",col='blue')
         text(x=354+10,y=0.9*max(x$obseff2),lab="Summer",col='blue')
         abline(v=079,col='blue')
         abline(v=171,col='blue')
         abline(v=263,col='blue')
         abline(v=354,col='blue')
         }
       }
     plot(x=x$period,y=x$obscat,main="",xlab=tstep,ylab=paste("Catch (",mult,")",sep=""),axes=FALSE)
     axis(side=1,at=seq(head(x$period,1),tail(x$period,1),1))
     axis(side=2,at=NULL)
     obscat.trend   <- loess(x$obscat~x$period,span=span)
     obscat.pred    <- predict(obscat.trend)
     lines(x=x$period,y=obscat.pred,col="blue",lwd=1)
     if(hem=="N")
       {
       if(tstep=="Week")
         {
         text(x=12+2,y=0.9*max(x$obscat),lab="Spring",col='blue')
         text(x=25+2,y=0.9*max(x$obscat),lab="Summer",col='blue')
         text(x=38+2,y=0.9*max(x$obscat),lab="Fall",col='blue')
         text(x=51+2,y=0.9*max(x$obscat),lab="Winter",col='blue')
         abline(v=12,col='blue')
         abline(v=25,col='blue')
         abline(v=38,col='blue')
         abline(v=51,col='blue')
         }
       else
         {
         text(x=079+10,y=0.9*max(x$obscat),lab="Spring",col='blue')
         text(x=171+10,y=0.9*max(x$obscat),lab="Summer",col='blue')
         text(x=263+10,y=0.9*max(x$obscat),lab="Fall",col='blue')
         text(x=354+10,y=0.9*max(x$obscat),lab="Winter",col='blue')
         abline(v=079,col='blue')
         abline(v=171,col='blue')
         abline(v=263,col='blue')
         abline(v=354,col='blue')
         }
       }
     else
       {
       if(tstep=="Week")
         {
         text(x=12+2,y=0.9*max(x$obscat),lab="Fall",col='blue')
         text(x=25+2,y=0.9*max(x$obscat),lab="Winter",col='blue')
         text(x=38+2,y=0.9*max(x$obscat),lab="Spring",col='blue')
         text(x=51+2,y=0.9*max(x$obscat),lab="Summer",col='blue')
         abline(v=12,col='blue')
         abline(v=25,col='blue')
         abline(v=38,col='blue')
         abline(v=51,col='blue')
         }
       else
         {
         text(x=079+10,y=0.9*max(x$obscat),lab="Fall",col='blue')
         text(x=171+10,y=0.9*max(x$obscat),lab="Winter",col='blue')
         text(x=263+10,y=0.9*max(x$obscat),lab="Spring",col='blue')
         text(x=354+10,y=0.9*max(x$obscat),lab="Summer",col='blue')
         abline(v=079,col='blue')
         abline(v=171,col='blue')
         abline(v=263,col='blue')
         abline(v=354,col='blue')
         }
       }
     plot(x=x$period,y=x$obsmbm,xlab=tstep,ylab=paste("Mean Body Mass (",bmunit,")",sep=""),axes=FALSE)
     axis(side=1,at=seq(head(x$period,1),tail(x$period,1),1))
     axis(side=2,at=NULL)
     if(hem=="N")
       {
       if(tstep=="Week")
         {
         text(x=12+2,y=0.9*max(x$obsmbm),lab="Spring",col='blue')
         text(x=25+2,y=0.9*max(x$obsmbm),lab="Summer",col='blue')
         text(x=38+2,y=0.9*max(x$obsmbm),lab="Fall",col='blue')
         text(x=51+2,y=0.9*max(x$obsmbm),lab="Winter",col='blue')
         abline(v=12,col='blue')
         abline(v=25,col='blue')
         abline(v=38,col='blue')
         abline(v=51,col='blue')
         }
       else
         {
         text(x=079+10,y=0.9*max(x$obsmbm),lab="Spring",col='blue')
         text(x=171+10,y=0.9*max(x$obsmbm),lab="Summer",col='blue')
         text(x=263+10,y=0.9*max(x$obsmbm),lab="Fall",col='blue')
         text(x=354+10,y=0.9*max(x$obsmbm),lab="Winter",col='blue')
         abline(v=079,col='blue')
         abline(v=171,col='blue')
         abline(v=263,col='blue')
         abline(v=354,col='blue')
         }
       }
     else
       {
       if(tstep=="Week")
         {
         text(x=12+2,y=0.9*max(x$obsmbm),lab="Fall",col='blue')
         text(x=25+2,y=0.9*max(x$obsmbm),lab="Winter",col='blue')
         text(x=38+2,y=0.9*max(x$obsmbm),lab="Spring",col='blue')
         text(x=51+2,y=0.9*max(x$obsmbm),lab="Summer",col='blue')
         abline(v=12,col='blue')
         abline(v=25,col='blue')
         abline(v=38,col='blue')
         abline(v=51,col='blue')
         }
       else
         {
         text(x=079+10,y=0.9*max(x$obsmbm),lab="Fall",col='blue')
         text(x=171+10,y=0.9*max(x$obsmbm),lab="Winter",col='blue')
         text(x=263+10,y=0.9*max(x$obsmbm),lab="Spring",col='blue')
         text(x=354+10,y=0.9*max(x$obsmbm),lab="Summer",col='blue')
         abline(v=079,col='blue')
         abline(v=171,col='blue')
         abline(v=263,col='blue')
         abline(v=354,col='blue')
         }
       }
     mtext(side=3,outer=TRUE,text=top.text)
     options(warn=0)
    }

